import os
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.websearch.begemot import BW_RESOURCES


class BuildBegemotBstr(YaMakeTask):
    type = 'BUILD_BEGEMOT_BSTR'
    resources = BW_RESOURCES['Bstr']
    execution_space = 60 * 1024
    input_parameters = [
        build_params.UseArcadiaApiFuse,
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch
    ]

    def get_build_def_flags(self):
        return '-DNO_STRIP=yes'

    def get_targets(self):
        return [os.path.dirname(r.arcadia_build_path) for r in self.resources]

    def get_resources(self):
        resources = {}
        for r in self.resources:
            resources[r.name] = {
                'description': r.name,
                'resource_type': r,
                'resource_path': os.path.join(os.path.basename(r.arcadia_build_path), os.path.basename(r.arcadia_build_path)),
            }
        return resources

    def get_arts(self):
        return [{
            'path': r.arcadia_build_path,
            'dest': os.path.basename(r.arcadia_build_path),
        } for r in self.resources]

    def post_build(self, source_dir, output_dir, pack_dir):
        for r in self.resources:
            if self.ctx.get(r.name):
                self.save_parent_task_resource(os.path.join(output_dir, r.arcadia_build_path), self.ctx[r.name])
