import os

from .build_task import BuildTask

from sandbox import sdk2


def _build_path(arc_path):
    parts = arc_path.rsplit('/', 2)
    if len(parts) < 3:
        return arc_path
    return os.path.join(parts[0], parts[1])


class BuildExecutable(BuildTask):
    def __init__(self, arcadia_url, targets, selected_targets, def_flags, task):
        self._arcadia_url = arcadia_url
        self._targets = targets
        self._selected_targets = selected_targets
        self._def_falgs = def_flags
        self._task = task

    def get_build_def_flags(self):
        return '-DSANDBOX_TASK_ID={} {additional_flags}'.format(self._task.id, additional_flags=self._def_falgs)

    def get_targets(self):
        return [
            _build_path(self._targets[resource_name].arcadia_build_path) for resource_name in self._selected_targets
        ]

    def get_arts(self):
        return [
            {'path': self._targets[resource_name].arcadia_build_path} for resource_name in self._selected_targets
        ]
    
    def post_build(self, source_dir, output_dir, pack_dir):
        self._task.Parameters.output_resources = {
            r: sdk2.Resource[r].find(task_id=self._task.id).first().id for r in self._selected_targets
        }
