import os

from .build_task import BuildTask

from sandbox import sdk2
from sandbox.projects.websearch.upper.resources import FastDataDeployer


class BuildFastDataDeployer(BuildTask):
    def __init__(self, arcadia_url, task):
        self._arcadia_url = arcadia_url
        self._task = task
        self._resources = [FastDataDeployer]
        self._build_path = 'search/tools/fast_data_deployment/deployer'

    def get_targets(self):
        return [os.path.dirname(self._build_path) for r in self._resources]

    def get_arts(self):
        return [{
            'path': self._build_path,
            'dest': os.path.basename(self._build_path)
        } for r in self._resources]

    def post_build(self, source_dir, output_dir, pack_dir):
        self._task.Parameters.output_resources = {
            r.name: sdk2.Resource[r.name].find(task_id=self._task.id).first().id for r in self._resources
        }
