import os
import shutil

from .build_task import BuildTask

from sandbox import sdk2


class CollectStaticFiles(BuildTask):
    def __init__(self, task, static_targets, static_resources):
        self._task = task
        self._static_targets = static_targets
        self._static_resources = static_resources
    
    def pre_build(self, source_dir):
        for target in self._static_targets:
            res = self._static_resources[target]
            src = res.arcadia_build_path
            shutil.copyfile(os.path.join(source_dir, src), os.path.basename(src))
            res(self._task, target, os.path.basename(src))
        
    def get_arts(self):
        return []

    def post_build(self, source_dir, output_dir, pack_dir):
        self._task.Parameters.output_resources = {
            r: sdk2.Resource[r].find(task_id=self._task.id).first().id for r in self._static_targets
        }
