# -*- coding: utf-8 -*-

import os

import sandbox.projects.websearch.begemot.resources as resource_types

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.channel import channel

import sandbox.projects.common.build.parameters as build_params


class BuildBegemotConfig(task.SandboxTask):

    type = 'BUILD_BEGEMOT_CONFIG'
    execution_space = 50
    input_parameters = [
        build_params.ArcadiaUrl,
    ]

    def on_enqueue(self):
        self.create_resource(
            resource_type=resource_types.BEGEMOT_CONFIG,
            description=self.description,
            resource_path='config',
        )

    def on_execute(self):
        parsed_url = Arcadia.parse_url(self.ctx[build_params.ArcadiaUrl.name])
        modified_path = os.path.join(parsed_url.path, resource_types.BEGEMOT_CONFIG.arcadia_build_path)
        modified_url = Arcadia.replace(self.ctx[build_params.ArcadiaUrl.name], path=modified_path)

        resources = channel.sandbox.list_resources(resource_type=resource_types.BEGEMOT_CONFIG, task_id=self.id)
        for resource in resources:
            Arcadia.export(modified_url, resource.path)
            # Проверяем, передавал ли родительский таск id ресурса, который нужно заполнить
            if self.ctx.get(resource_types.BEGEMOT_CONFIG.name):
                self.save_parent_task_resource(resource.path, self.ctx[resource_types.BEGEMOT_CONFIG.name])


__Task__ = BuildBegemotConfig
