import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
from sandbox.common.errors import TaskFailure


class CheckMemlockUnlimited(sdk2.Task):
    @sdk2.header()
    def header(self):
        return (self.Context.result or '').replace('\n', '<br />\n')

    def validate_memlock_limit(self):
        # web/daemons/scripts/nanny_tidiness
        binary_path = str(sdk2.ResourceData(sdk2.Resource.find(id=655874704).first()).path)
        args = [binary_path, '--commit', 'ulimit']
        env = os.environ.copy()
        env['OAUTH_NANNY'] = sdk2.Vault.data('BEGEMOT', 'Begemot Nanny token')
        self.Context.result = subprocess.check_output(args, env=env)

    def on_execute(self):
        self.validate_memlock_limit()
        if self.Context.result:
            raise TaskFailure('Output of nanny_tidiness is not empty')
