import os
import shutil

from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.sdk2.helpers import subprocess


class CompareBegemotFreshBuildAndDistBuild(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 90 << 10

    class Parameters(sdk2.Parameters):
        arcadia_revision = sdk2.parameters.Integer('Arcadia revision')
        fail_on_any_error = True

    def on_execute(self):
        import sandbox.projects.WizardRuntimeBuild as WizardRuntimeBuild

        wizard_runtime_build_class = sdk2.Task[WizardRuntimeBuild.WizardRuntimeBuild.type]
        with self.memoize_stage.run_tasks(commit_on_entrance=False):
            self.Context.subtasks = [
                wizard_runtime_build_class(
                    self, description='Get first data',
                    arcadia_revision=self.Parameters.arcadia_revision,
                    production_build=False,
                    build_system=build_system
                ).enqueue().id
                for build_system in ['ya_force', 'semi_distbuild']
            ]

            raise sdk2.WaitTask(self.Context.subtasks, Status.Group.FINISH, wait_all=True)

        with self.memoize_stage.build_diff(commit_on_entrance=False):
            for i in range(2):
                list_resource = sdk2.Resource.find(task_id=self.Context.subtasks[i]).limit(50)

                for resource in list_resource:
                    name_resource = str(resource.type)

                    if not name_resource.startswith('BEGEMOT_FRESH_DATA_') or name_resource.endswith('PACKED'):
                        continue

                    path_for_resource = str(sdk2.ResourceData(resource).path)
                    new_path_for_resource = os.path.join(str(i + 1), name_resource)

                    shutil.copytree(path_for_resource, new_path_for_resource)
                    os.system('chmod -R 777 ' + new_path_for_resource)

                    if os.path.isfile(os.path.join(new_path_for_resource, 'version.pb.txt')):
                        os.remove(os.path.join(new_path_for_resource, 'version.pb.txt'))

            with sdk2.helpers.ProcessLog(self, logger='diff') as pl:
                pl.logger.propagate = 1
                subprocess.check_call(['diff', '-r', '1', '2'], stderr=subprocess.STDOUT, stdout=pl.stdout)
