def split_path(path):
    path = path.strip()
    if path.startswith("./"):
        path = path[1:]

    result = []
    for item in path.split('/'):
        if item:
            result.append(item)

    return result


class PathTree(object):
    def __init__(self):
        self.attributes = {}
        self.children = {}

    def make_child(self, key):
        result = PathTree()
        self.children[key] = result
        return result

    def set_attribute(self, key, value):
        for i in range(0, len(key)):
            if key[i] != '$':
                if i > 0:
                    key = key[i:]
                break
        self.attributes[key] = value

    def fill_attributes(self, path, attributes, offset=0):
        if isinstance(path, basestring): path = split_path(path)

        if offset == len(path):
            for key in attributes:
                self.set_attribute(key, attributes[key])
            return

        child = self.attributes.get(path[offset], None)
        if child is None:
            child = self.make_child(path[offset])
        child.fill_attributes(path, attributes, offset + 1)

    def fill_attribute(self, path, key, value, offset=0):
        self.fill_attributes(path, {
            key: value
        }, offset)

    def find_attribute(self, path, attribute, default=None, offset=0):
        if isinstance(path, basestring): path = split_path(path)

        result = None
        if offset == len(path):
            result = self.attributes.get(attribute, None)
            if result is None: return default
            return result

        child = self.children.get(path[offset], None)
        if child is not None: result = child.find_attribute(path, attribute, None, offset + 1)

        if result is None:
            child = self.children.get("*", None)
            if child is not None: result = child.find_attribute(path, attribute, None, offset + 1)

        if result is None:
            child = self.children.get("**", None)
            if child is not None:
                if len(child.children) == 0:
                    result = child.find_attribute(path, attribute, None, len(path))
                else:
                    for i in range(len(path), offset):
                        result = child.find_attribute(path, attribute, None, i)
                        if result is not None: break

        if result is None: return default
        return result


class TreeConfig(PathTree):
    def __init__(self):
        self.default = PathTree()
        super(TreeConfig, self).__init__()

    def make_child(self, key):
        result = TreeConfig()
        self.children[key] = result
        return result

    def find_attribute(self, path, attribute, default=None, offset=0):
        if isinstance(path, basestring): path = split_path(path)

        result = super(TreeConfig, self).find_attribute(path, attribute, None, offset)
        if result is None: result = self.default.find_attribute(path, attribute, None, offset)

        if result is None: return default
        return result


def load_config(config, dictionary):
    for key in dictionary:
        value = dictionary[key]
        if key.startswith("$"):
            if key == "$default":
                for path in value:
                    config.default.fill_attributes(path, value[path])
            else:
                config.set_attribute(key, value)
        else:
            child = config.children.get(key, None)
            if child is None: child = config.make_child(key)
            load_config(child, value)
    return config
