import datetime
import logging
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class CopyBegemotEventlogs(sdk2.Task):
    """Copy eventlogs task"""

    class Requirements(sdk2.Task.Requirements):
        disk_space = 300
        ram = 1024
        cores = 1
        environments = (
            environments.PipEnvironment('yandex-yt', version='0.10.8'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yandex-yt-transfer-manager-client')
        )

    class Parameters(sdk2.Task.Parameters):
        services = sdk2.parameters.List("list of map nodes to sync", default=["production_wizard_web", "production_wizard_service", "begemot_testing_worker_bravo"])
        src_prefix = sdk2.parameters.String("Src prefix", default="//home/search-runtime/eventlogdata")
        dst_prefix = sdk2.parameters.String("Dst prefix", default="//home/begemot/eventlogdata")
        copy_from = sdk2.parameters.String("Source YT cluster", default="arnold")
        copy_to = sdk2.parameters.String("Destination YT cluster", default="hahn")

    def on_execute(self):
        import yt.logger as yt_logger
        import yt.wrapper as yt
        import yt.transfer_manager.client as tm
        logging.getLogger().setLevel(logging.DEBUG)
        yt_logger.LOGGER.setLevel(logging.DEBUG)
        yt_logger.LOGGER.propagate = True

        token = sdk2.Vault.data('yt_token_for_testenv')
        dst_yt = yt.YtClient(self.Parameters.copy_to, token)
        src_yt = yt.YtClient(self.Parameters.copy_from, token)
        tm_client = tm.TransferManager(token=token)

        for service in self.Parameters.services:
            for client, prefix in [(dst_yt, self.Parameters.dst_prefix), (src_yt, self.Parameters.src_prefix)]:
                path = yt.ypath_join(prefix, service)
                if not client.exists(path):
                    client.mkdir(path)

        self.set_info('Starting remote copy')
        with dst_yt.Transaction():
            for service in self.Parameters.services:
                path = yt.ypath_join(self.Parameters.src_prefix, service)
                for src_table in sorted(src_yt.list(path, absolute=True))[:-1]:
                    dst_table = src_table.replace(self.Parameters.src_prefix, self.Parameters.dst_prefix)
                    if not dst_yt.exists(dst_table):
                        tm_client.add_task(self.Parameters.copy_from, src_table, self.Parameters.copy_to, dst_table, sync=True)
                        yt.YtClient(self.Parameters.copy_to, token).set(dst_table + '/@expiration_time', (datetime.datetime.now() + datetime.timedelta(days=4)).isoformat("T"))
        self.set_info('Done')
