from sandbox.projects.common.wizard.printwizard import postprocess


def drop_host_info(data):
    if not isinstance(data, dict):
        return
    rules = data.get("rules", None)
    if rules:
        rules.pop(".version", None)
        print_version = rules.get("PrintVersion")
        if print_version:
            print_version.pop("runs_at", None)
        rules.pop("Headers", None)
        request_params = rules.get("RequestParams", None)
        if request_params:
            request_params.pop("YCookie", None)
        region = rules.get("Region")
        if region:
            region.pop("DefaultRequestLocalTime", None)


def drop_version(data):
    if not isinstance(data, dict):
        return
    rules = data.get("rules", None)
    if rules:
        rules.pop("PrintVersion", None)
        rules.pop(".version", None)


def format_factors_str(x):
    xs = {}
    for factor in x.split(';'):
        k, _, v = factor.partition('=')
        xs.setdefault(k, []).append(v)
    return xs


def format_factors(data):
    if not isinstance(data, dict):
        return
    for field in ("relev", "rearr"):
        if field in data:
            data[field] = format_factors_str(data[field])


def normalize_all(data):
    if not isinstance(data, dict):
        return
    drop_version(data)
    format_factors(data)
    postprocess(data, unpackreqbundle=None, unpackrichtree=None)
