#!/usr/bin/python
# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.sandboxsdk.channel import channel
import sandbox.projects.websearch.begemot.resources as br


class GetBegemotReleasesPerf(sdk2.Task):
    logger = logging.getLogger('TASK_LOGGER')
    logger.setLevel(logging.DEBUG)

    class Parameters(sdk2.Parameters):
        releases_count = sdk2.parameters.Integer('Count of releases to test', default=20)

    class Context(sdk2.Context):
        perf_tasks = {}
        results = {}

    def on_execute(self):
        with self.memoize_stage.start_perf_tasks:
            releases = channel.sandbox.list_releases(
                resource_type=br.BEGEMOT_EXECUTABLE.name, limit=self.Parameters.releases_count, order_by='-id'
            )
            self.logger.info('releases: %s' % str(releases))
            for release in releases:
                self.logger.info('release task id: %s' % str(release.task_id))
                release_task = sdk2.Task.find(id=release.task_id).first()
                release_number = release_task.Context.release_number
                self.logger.info('branch: %s' % release_number)
                task_class = sdk2.Task['BEGEMOT_TEST_PERFORMANCE']
                sub_task = task_class(
                    self,
                    description='Perf test for begemot release %s' % release_number,
                    begemot_binary=br.BEGEMOT_EXECUTABLE.find(task_id=release_task.id).first().id,
                    begemot_config=br.BEGEMOT_CONFIG.find(task_id=release_task.id).first().id,
                    begemot_shard=br.BEGEMOT_ISS_WIZARD.find(task_id=release_task.id).first().id,
                    begemot_plan=248154065,
                    dolbilka_executor_sessions=3,
                    dolbilka_executor_max_simultaneous_requests=26,
                    dolbilka_executor_mode='finger',
                    dolbilka_executor_requests_limit=50000,
                    dolbilka_request_timeout=600,
                    profiling_type='on_cpu',
                )
                sub_task.Requirements.host = 'sandbox1131'
                sub_task.save()
                self.Context.perf_tasks[release_task.Context.release_number] = sub_task.enqueue().id
            raise sdk2.WaitTask(self.Context.perf_tasks.values(), statuses=Status.Group.FINISH)
        with self.memoize_stage.get_results(commit_on_entrance=False):
            for release, task_id in self.Context.perf_tasks.items():
                self.Context.results[release] = sdk2.Task.find(id=task_id, children=True).first().Context.results

    @sdk2.header()
    def header(self):
        pass
