# -*- coding: utf-8 -*-#

import os
import logging
from sandbox import sdk2

from sandbox.projects import resource_types
from sandbox.projects.app_host import resources as app_host_resources
from sandbox.projects.common.utils import sync_resource
from sandbox.projects.websearch.begemot import parameters as bp
from sandbox.projects.websearch.begemot import resources as br
from sandbox.projects.websearch.begemot.common import ApphostGraph
from sandbox.projects.websearch.begemot.common.fast_build import ShardSyncHelper
from sandbox.projects.websearch.begemot.tasks.GetBegemotWorkerAndMergerResponses import ApphostConfigurator
import sandbox.common.types.task as ctt
import sandbox.projects.websearch.begemot.tasks.GetBegemotWorkerAndMergerResponses as gbw


class GetBegemotWorkerLingboostResponses(gbw.GetBegemotWorkerAndMergerResponses):
    '''
    Get responses from begemot-worker-lingboost graph
    '''
    logger = logging.getLogger('GetBegemotWorkerLingboostResponses')

    class Parameters(sdk2.Parameters):
        begemot_binary = bp.BegemotExecutableResource()
        begemot_worker_binary = sdk2.parameters.Resource(
            'Begemot worker binary if different to merger binary',
            required=False
        )
        begemot_config = bp.BegemotConfigResource()

        fast_build_config = bp.FastBuildConfigResource(required=True)
        begemot_fresh = bp.FreshResource()
        requests_plan = bp.BegemotQueriesResource()

        apphost_port = sdk2.parameters.Integer('Apphost Port', default=8870)

    def init_apphost(self, port):
        ah_res = sdk2.Resource["APP_HOST_DAEMON_EXECUTABLE"].find(status=ctt.Status.RELEASED).order(-sdk2.Task.id).first()
        ah_res_path = str(sdk2.ResourceData(ah_res).path)
        self.graphs_path = str(self.path('raw_graphs'))
        self.backend_path = str(self.path('sample_backend'))
        self._checkout_graphs()
        self._checkout_sample_backend()
        graph = ApphostGraph(self.graphs_path, 'LINGBOOST_INIT', self.worker_port, self.merger_port, backends_path=self.backend_path, separate_backends=True, merger_type='LINGBOOST_MERGER')
        graph, backends = graph.generate_lingboost_graph()
        return ApphostConfigurator(task=self, ah_resource=ah_res_path, graph=graph, port=port, backends=backends).get_apphost()

    def on_enqueue(self):
        self.Context.out_resource_id = br.BEGEMOT_RESPONSES_RESULT(
            self,
            'Begemot responses output',
            'output.txt'
        ).id

        data_size = shard_size = ShardSyncHelper(self.Parameters.fast_build_config).get_shard_size()

        if self.Parameters.begemot_fresh:
            data_size += self.Parameters.begemot_fresh.size

        self.Requirements.disk_space = self.Requirements.ram = 2 * data_size // 1024 // 1024 + 10 * 1024  # 10 GiB
        self.Requirements.disk_space += shard_size >> 20 # Because of rules copying

    def on_execute(self):
        os.environ["MKL_CBWR"] = "COMPATIBLE"
        self.begemot_config = os.path.join(str(sdk2.ResourceData(self.Parameters.begemot_config).path), 'worker.cfg')
        worker = self.init_worker()
        self.worker_port = int(worker.port)
        self.merger_port = self.worker_port + 10
        merger = self.init_worker(self.merger_port)
        apphost = self.init_apphost(port=self.Parameters.apphost_port)
        self.apphost_port = int(apphost.port)
        with worker, merger, apphost:
            self.shoot()
