# -*- coding: utf-8 -*-
import os
import shutil

from sandbox import sdk2
from sandbox.projects.websearch.begemot import resources as br

import sandbox.projects.websearch.begemot.tasks.GetBegemotResponses as gbr


class GetFailCacheHit(gbr.GetBegemotResponses):
    '''
    Get failcache hit
    '''
    class Parameters(gbr.GetBegemotResponses.Parameters):
        pass

    def on_enqueue(self):
        super(GetFailCacheHit, self).on_enqueue()
        self.Context.cache_hit_resource_id = br.BEGEMOT_FAILCACHE_HIT_RESULT(
            self,
            'GetFailCacheHit output',
            'cache_hit.txt'
        ).id

    def _get_cache_size_bytes(self):
        return 0

    def on_execute(self):
        total = 0
        requests = str(sdk2.ResourceData(self.Parameters.requests_plan).path)
        with open(requests, 'r') as input_file:
            for line in input_file:
                if ', {"meta": {}, "name": "WIZARD", "results": [{"type": "wizard"}]}]' not in line:
                    total += 1
        super(GetFailCacheHit, self).on_execute()
        output = str(sdk2.Resource[self.Context.out_resource_id].path)
        cache_hit = str(sdk2.Resource[self.Context.cache_hit_resource_id].path)
        hits = 0
        with open(output, 'r') as output_file:
            for line in output_file:
                if '"FromFailCache":"yes"' in line:
                    hits += 1
        self.set_info('Cache hit: %.2f%%' % (hits * 100.0 / total))
        self.set_info('Hits: {}, Total: {}'.format(hits, total))
        with open(cache_hit, 'w') as output_file:
            output_file.write(str(hits * 1.0 / total))
