# coding: utf-8

import logging

import sandbox.common.types.resource as ctr
import sandbox.projects.websearch.begemot.resources as br

from sandbox import sdk2
from sandbox.sandboxsdk import process


class QuotasCorrectionScript(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        last_built_nanny_tidiness = sdk2.parameters.Bool("Use last built nanny tidiness")
        with last_built_nanny_tidiness.value[False]:
            nanny_tidiness_resource = sdk2.parameters.Resource(
                "Nanny tidiness binary",
                resource_type=br.BEGEMOT_NANNY_TIDINESS,
                required=True,
            )
        is_quiet = sdk2.parameters.Bool("Print only warnings and errors", default=False)
        mask = sdk2.parameters.String("Services Nanny path mask. Kind or service/kind. E.g., \"hamster\" or \"worker_wizard2/hamster\"", default=None)
        name_mask = sdk2.parameters.String("Services name mask. E.g. \"(begemot_worker_mf_production_sas|production_wizard_service_market)\"", default=None)
        services = sdk2.parameters.String("Specify certain services(comma-separated). Warning: --mask and --name-mask are ignored if --services specified", default=None)

    def on_execute(self):
        if self.Parameters.last_built_nanny_tidiness:
            binary = list(sdk2.Resource.find(
                resource_type=br.BEGEMOT_NANNY_TIDINESS,
                state=ctr.State.READY,
            ).limit(1))[0]
            logging.info("Last built nanny tidiness resource id: %s", binary.id)
        else:
            binary = self.Parameters.nanny_tidiness_resource
        cmd = [
                str(sdk2.ResourceData(binary).path),
        ]
        if self.Parameters.is_quiet:
            cmd.append('--quiet')
        if self.Parameters.mask:
            cmd.append('--mask {}'.format(self.Parameters.mask))
        if self.Parameters.name_mask:
            cmd.append('--name-mask {}'.format(self.Parameters.name_mask))
        if self.Parameters.services:
            cmd.append('--services {}'.format(self.Parameters.services))
        cmd.append('recalc-groups')
        with sdk2.helpers.ProcessLog(logger="nanny_tidiness") as pl:
            process.run_process(" ".join(cmd), shell=True, stdout=pl.stdout, stderr=pl.stderr)
