import logging

from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.projects.common import binary_task
from sandbox.projects.release_machine.tasks.ReleaseRmComponent2 import ReleaseRmComponent2


class ReleaseBegemotRmPush(ReleaseRmComponent2):

    class Parameters(ReleaseRmComponent2.Parameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)

        task_name = sdk2.parameters.String(
            'Cache guess task name',
            default='MIDDLE_SEARCH_CACHE_HIT_GUESS'
        )

    def get_cache_miss(self):
        task_tag = "TESTENV-JOB-{}".format(self.Parameters.task_name)
        db_tag = "TESTENV-DATABASE-WS-{}-{}".format(
            self.Parameters.component_name.upper(),
            self.Parameters.major_release_num
        )
        for task in sdk2.Task.find(tags=[task_tag], hidden=True, status=ctt.Status.SUCCESS).limit(50):
            if db_tag in self.server.task[task.id].read()["tags"]:
                logging.debug("Found CacheHitGuess task #{}".format(task.id))
                return float(task.Context.answers_diff)

        return None

    def on_execute(self):
        cache_miss = self.get_cache_miss()
        self.set_info("Cache miss: {}".format(cache_miss))
        msg = ""
        if cache_miss is not None:
            msg = "Cache miss is {:.2f}%.".format(cache_miss)
        if cache_miss is None or cache_miss > 40:
            msg = " ".join([msg, "Do not deploy from 09:00 till 21:00."])

        self.Parameters.additional_release_notes = msg
        ReleaseRmComponent2.on_execute(self)
