#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import json
import logging
import datetime
from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.common.arcadia import sdk as sdk
from sandbox.projects.websearch.begemot.resources import SAMOGON_BEGEMOT_FRESH_PACKAGE, BEGEMOT_BSTR


class SamogonBegemotFreshPackage(sdk2.Task):
    """
    Build samogon package with fresh torrents and yt feedback paths
    """
    __logger = logging.getLogger('TASK_LOGGER')
    __logger.setLevel(logging.DEBUG)

    class Parameters(sdk2.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia root url', default_value='arcadia:/arc/trunk/arcadia')
        arcadia_subpath = sdk2.parameters.String('Arcadia subpath', default_value='web/daemons/begemot/samogon_fresh')
        bstr = sdk2.parameters.Resource('Bstr binary', resource_type=BEGEMOT_BSTR)
        config = sdk2.parameters.JSON('Samogon fresh config', required=True)

    def on_execute(self):
        arcadia_path = Arcadia.checkout(self.Parameters.arcadia_url, 'arcadia', depth='immediates')
        service_path = os.path.join(arcadia_path, self.Parameters.arcadia_subpath)
        Arcadia.update(service_path, set_depth='infinity', parents=True)
        with open(os.path.join(service_path, 'config.json'), 'w') as fp:
            json.dump(self.Parameters.config, fp, indent=2)
        package_path = os.path.join(service_path, 'package.json')
        if self.Parameters.bstr:
            with open(package_path) as fp:
                package = json.load(fp)
                bstr = [i for i in package['data'] if i['source']['type'] == 'SANDBOX_RESOURCE'][0]
                bstr['source']['id'] = self.Parameters.bstr.id
            with open(package_path, 'w') as fp:
                json.dump(package, fp, indent=2)
        sdk.do_package('.', [package_path], checkout=True, sandbox_task_id=self.id)
        with open('packages.json') as fp:
            packages = json.load(fp)
            SAMOGON_BEGEMOT_FRESH_PACKAGE(
                self, datetime.datetime.utcnow().strftime('Fresh build %Y-%m-%dT%H:%M:%SZ'), packages[0]['path']
            )
            self.__logger.info('packages: %s' % packages)
