from requests import Session
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry
from functools import reduce
from time import time

import constants as c


def gmean(array):
    prod = reduce(lambda x, y: x * y, array)
    return prod ** (1 / len(array))


def get_quantiles(rulenames):
    try:
        from infra.yasm.yasmapi import GolovanRequest
    except:
        from yasmapi import GolovanRequest
    host = 'ASEARCH'
    period = 3600
    et = int(time())
    st = et - 30 * 24 * period  # 30 days
    tag = 'itype=begemot;ctype=prod,prestable'
    signal2name = {'{0}:quant~begemot-WORKER-{1}-TIME_dhhh~99'.format(tag, name): name
        for name in rulenames}
    packs_of_signals = [list(signal2name.keys())[i: i + 100] for i in range(0, len(signal2name), 100)]

    response = []
    for pack in packs_of_signals:
        done = False
        for try_index in range(5):
            try:
                for _, signal_dict in GolovanRequest(host, period, st, et, pack):
                    response += [(signal2name[signal], value) for signal, value in signal_dict.items()]
            except:
                continue
            else:
                done = True
                break
        if not done:
            raise BaseException('GolovanRequest was not received')

    quantiles = {name: [value for current_rulename, value in response
        if current_rulename == name and value is not None] for name in rulenames}
    return {name: float(gmean(quantiles[name])) if quantiles[name] else 0.0 for name in rulenames}


def get_sizes():  # in mb
    session = Session()
    session.headers.update({'Content-Type': 'application/json'})
    session.mount('https://', HTTPAdapter(max_retries=Retry(total=10, backoff_factor=0.1, status_forcelist=[202])))

    result = {}
    for shard_name in c.SIGNIFICANT_SHARDS:
        params = {
            'limit': 1,
            'offset': 0,
            'all_tags': 'true',
            'status': 'SUCCESS',
            'children': 'true',
            'hidden': 'true',
            'type': 'BUILD_BEGEMOT_DATA',
            'tags': '%2C'.join([
                'TESTENV-DATABASE-WS-BEGEMOT-TRUNK',
                'TESTENV-COMMIT-CHECK',
                'TESTENV-TE-JOB',
                shard_name.upper(),
            ]),
        }
        params_str = '&'.join([str(k) + '=' + str(v) for k, v in params.items()])
        request_url = '{url}/task?{params}'.format(url=c.BASE_URL, params=params_str)  # BEGEMOT-1367
        task_id = session.get(request_url).json()['items'][0]['id']
        request_url = '{url}/task/{task_id}/context'.format(url=c.BASE_URL, task_id=str(task_id))
        answer = session.get(request_url).json()
        rule_sizes = answer['rules_size_mb']  # BEGEMOT-1337
        result.update(rule_sizes)
    return result
