# coding: utf-8

from sandbox.common.types.client import Tag

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common import requests_wrapper
from sandbox.projects.common.wizard import parameters as wp

import datetime
import json
import logging
import os
import uuid

_API = 'http://freud.yt.yandex.net/api/v3'


class WizardReducer(SandboxTask):
    type = 'WIZARD_REDUCER'
    input_parameters = (wp.WizardReducer, wp.Shard)
    execution_space = 47 * 1024
    disk_space = 47 * 1024

    client_tags = Tag.GENERIC

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True
        self.ctx['kill_timeout'] = 15 * 60 * 60
        self.ctx['eventlog'] = '//home/begemot/eventlogdata/production_wizard_web'

    @property
    def footer(self):
        if 'req_errors_count' in self.ctx:
            return [{
                "helperName": "",
                "content": "<b>Errors count</b>: {}".format(self.ctx['req_errors_count'])
            }]

    def on_execute(self):
        self.info += 'Wizard is no more supported, use begemot\nhttps://wiki.yandex-team.ru/begemot/begemotreducer/'
        config_dir = "/dev/null"
        binary = self.sync_resource(self.ctx[wp.WizardReducer.name])
        shard = self.sync_resource(self.ctx[wp.Shard.name])
        env = os.environ.copy()
        env['YT_TOKEN'] = self.get_vault_data('SEARCH-RELEASERS', 'yt_token_for_testenv')

        headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'OAuth {}'.format(env['YT_TOKEN'])
        }
        evlog_path = self.ctx['eventlog']

        log_request = requests_wrapper.get(
            "{}/list?path={}".format(_API, evlog_path),
            headers=headers,
        )
        log_request.raise_for_status()
        table = evlog_path + '/' + str(sorted([int(i) for i in json.loads(log_request.content)])[-2])
        output_table = "//home/begemot/tests-data/" + str(uuid.uuid4())
        logging.info('Downloaded resources')
        task_log = open('task.log', 'a')
        run_process([
            binary,
            "--input_path", table,
            "--output_path", output_table,
            "-m", "filter",
            "-m", "sort",
            "-m", "reduce",
            "-a", shard,
            "-y", config_dir + '/wizard-yaml.cfg',
            "--proxy", "freud",
            "--pool", "begemot",
            "--title", "testenv-wizard",
            "--extract_shard_prefix", "wizard/WIZARD_SHARD",
        ], shell=True, stdout=task_log, stderr=task_log, environment=env)
        r = requests_wrapper.put(
            "{}/set?path={}/@expiration_time".format(_API, output_table + '.error'),
            headers=headers,
            data=json.dumps((datetime.datetime.now() + datetime.timedelta(days=30)).isoformat("T"))
        )
        r.raise_for_status()
        r = requests_wrapper.put(
            "{}/set?path={}/@expiration_time".format(_API, output_table),
            headers=headers,
            data=json.dumps((datetime.datetime.now() + datetime.timedelta(days=1)).isoformat("T"))
        )
        r.raise_for_status()
        r = requests_wrapper.get(
            "{}/get?path={}/@".format(_API, output_table + '.error'),
            headers=headers,
        )
        r.raise_for_status()
        if json.loads(r.content)['row_count'] > 0:
            task_log.write(
                'error table is not empty: '
                'https://yt.yandex-team.ru/freud/#page=navigation&path={}'.format(
                    output_table + '.error'
                )
            )
        task_log.close()
        with open('task.log') as f:
            self.set_info(f.read())
        content_deserialized = json.loads(r.content)
        self.ctx['req_errors_count'] = content_deserialized['row_count']
        assert content_deserialized['row_count'] == 0


__Task__ = WizardReducer
