import numpy as np
import math


def deep_sum(x):
    while isinstance(x, list): x = np.sum(x)
    return x


def get_req_total_times(log):
    if len(log) == 0: return []

    reqs_cnt = len(log)
    sess_cnt = len(log[0])

    time_table = np.zeros((sess_cnt, reqs_cnt))
    for req_id in range(reqs_cnt):
        for sess_id in range(sess_cnt):
            time_table[sess_id][req_id] = deep_sum(log[req_id][sess_id])
    return time_table


def select_similar_session(log, cnt):
    if len(log) == 0: return []
    if cnt < 0: raise Exception()

    reqs_cnt = len(log)
    sess_cnt = len(log[0])

    time_table = get_req_total_times(log)

    corr = np.corrcoef(time_table)
    result = [_ for _ in range(sess_cnt)]
    corr_log_sum = [np.sum(map(math.log, corr[sess_id])) for sess_id in result]
    while len(result) > cnt:
        min_id = 0
        min_sum = corr_log_sum[result[0]]
        for i, x in enumerate(result):
            if corr_log_sum[x] < min_sum:
                min_id = i
                min_sum = corr_log_sum[x]
        result.pop(min_id)
        for x in result:
            corr_log_sum[x] -= corr[x][min_id]

    return [[log[req_id][sess_id] for sess_id in result] for req_id in range(reqs_cnt)]


def get_duration_stat(duration_list):
    res = {
        "Mean": np.mean(duration_list),
        "Sqrt variance": math.sqrt(np.var(duration_list)),
        "Median": np.median(duration_list),
        "Min": np.min(duration_list),
        "Max": np.max(duration_list)
    }
    for x in res:
        if isinstance(res[x], float): res[x] = round(res[x], 3)

    return res


def get_rules_stat_table(rules, log):
    rules_duration = [[] for _ in rules]

    def collect_rules_duration(element_index, element):
        if isinstance(element, list):
            for next_index, next_element in enumerate(element):
                collect_rules_duration(next_index, next_element)
        else:
            rules_duration[element_index].append(element)

    def collect_total_duration(element, buffer=None):
        if buffer is None: buffer = []
        if not isinstance(element, list): raise Exception()
        if len(element) == 0:
            return buffer
        if isinstance(element[0], (float, int)):
            buffer.append(np.sum(element))
        else:
            for x in element:
                collect_total_duration(x, buffer)
        return buffer

    collect_rules_duration(-1, log)
    result = []
    total_duration = deep_sum(log)
    for i, rule in enumerate(rules):
        rule_duration = rules_duration[i]
        rule_total_duration = np.sum(rule_duration)
        rule_prc = (100.0 * rule_total_duration) / total_duration
        rule_stat = {
            "#": rule,
            "%": round(rule_prc, 3)
        }
        rule_stat.update(get_duration_stat(rules_duration[i]))
        result.append((rule_total_duration, rule_stat))

    total_stat = {
        "#": "<b>Total</b>"
    }
    total_stat.update(get_duration_stat(collect_total_duration(log)))

    result.sort()
    result.append((None, total_stat))
    result.reverse()
    return [x[1] for x in result]
