# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sdk2.helpers import subprocess
from sandbox.common import errors
from sandbox.common.types.resource import State

from sandbox.projects.websearch.clickdaemon import resources
from sandbox.projects.websearch.params import ResourceWithLastReleasedValueByDefault


class UpdateWizardAlerts(sdk2.Task):
    """
        Calculates how much of wizards are covered with alerts
    """

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 50  # 50 Mb

        class Caches(sdk2.Requirements.Caches):
            pass  # do not use any shared caches

    class Parameters(sdk2.Task.Parameters):

        update_wizard_alerts_tool = ResourceWithLastReleasedValueByDefault(
            'Update Wizard Alerts tool (yweb/webdaemons/clickdaemon/tools/update_wizard_alerts/main)',
            resource_type=resources.UpdateWizardAlertsTool,
        )

        tokens_yav_secret_id = sdk2.parameters.String('Tokens yav secret id', required=True)
        dry_run = sdk2.parameters.Bool('Get realistic stderr output, but do not change juggler, solomon, etc', default=False)
        no_flow = sdk2.parameters.Bool('Turn off automatic flow and SPI generation for juggler checks', default=False)

    def on_create(self):
        self.Parameters.update_wizard_alerts_tool = sdk2.Resource.find(
            resource_type=resources.UpdateWizardAlertsTool,
            attrs={"released": "stable"},
            state=(State.READY)
        ).first()

    def on_execute(self):
        solomon_token = sdk2.Vault.data("{}[solomon]".format(self.Parameters.tokens_yav_secret_id))
        juggler_token = sdk2.Vault.data("{}[juggler]".format(self.Parameters.tokens_yav_secret_id))
        warden_token = sdk2.Vault.data("{}[warden]".format(self.Parameters.tokens_yav_secret_id))

        update_wizard_alerts_tool = str(sdk2.ResourceData(self.Parameters.update_wizard_alerts_tool).path)
        params_config = Arcadia.export(
            Arcadia.trunk_url('yweb/webdaemons/clickdaemon/tools/update_wizard_alerts/config/params_config.json'),
            'params_config.json'
        )

        update_wizard_alerts_tool_args = [
            update_wizard_alerts_tool,
            '-s', solomon_token,
            '-j', juggler_token,
            '-w', warden_token,
            '-p', params_config
        ]

        if self.Parameters.dry_run:
            update_wizard_alerts_tool_args.append("--dry_run")

        if self.Parameters.no_flow:
            update_wizard_alerts_tool_args.append("--no_flow")

        process = subprocess.Popen(update_wizard_alerts_tool_args)
        if process.wait():
            raise errors.TaskFailure()
