from sandbox import sdk2

DAILY = '1d'
HOURLY = '1h'
HALF_HOURLY = '30min'

LOG_TYPES = {
    'balancer_access_log': {
        'cypress_root': '//logs/l7-balancer-access-log',
        'scale': HOURLY,
        'report_keys': ['total'],
    },
    'redir_log': {
        'description': 'redir-log',
        'checked': True,
        'logs': [
            {
                'cypress_root': '//logs/redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/answ-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/collections-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/health-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/uslugi-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/ugc-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/hamster-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/talents-prod-clickdaemon-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/talents-test-clickdaemon-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/turbo-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/trip-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/trip-test-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/rmp-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/games-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/direct-redir-log',
                'scale': DAILY,
            },
            {
                'cypress_root': '//logs/morda-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/market-redir-perf-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/thefeed-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/commentator-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/org-landing-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/tracker-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/staff-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/intrasearch-redir-log',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/rmp-redir-log-test',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/maps-search-discovery-uni-log-test',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/maps-search-discovery-uni-log-prod',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/pcode-rum',
                'scale': HALF_HOURLY,
            },
            {
                'cypress_root': '//logs/products-redir-log',
                'scale': HALF_HOURLY,
            },
        ],
        'report_key': 'redir',
        'report_keys': ['redir', 'redir_robot'],
    },
    'clickdaemon_error_log': {
        'description': 'clickdaemon error-log',
        'checked': True,
        'logs': [
            {
                'cypress_root': '//logs/clickdaemon-err-log',
                'scale': HALF_HOURLY,
            }
        ],
        'report_key': 'error',
        'report_keys': ['error', 'error_robot'],
    },
    'unparsed_redir_log': {
        'description': 'unparsed redir-log',
        'checked': False,
        'logs': [
            {
                'cypress_root': '//home/logfeller/index/redir/redir-log/unparsed',
                'scale': DAILY,
            }
        ],
        'report_key': 'unparsed',
        'report_keys': ['unparsed', 'unparsed_robot'],
    },
}

LOG_TYPES_TO_CHECK = [
    'redir_log',
    'clickdaemon_error_log',
    'unparsed_redir_log',
]

REPORT_KEYS = list(item for cfg in LOG_TYPES.values() for item in cfg.get('report_keys'))

TEMPORARY_REQID_TABLES_PATH = "//home/search-runtime/redir-log-loss/1h"

with sdk2.parameters.CheckGroup('Log types') as log_types:
    for log_type in LOG_TYPES_TO_CHECK:
        cfg = LOG_TYPES[log_type]
        log_types.values[log_type] = log_types.Value(cfg['description'], checked=cfg['checked'])
