import logging

from sandbox import sdk2
import sandbox.projects.websearch.devops.libs.check_other_resources as cor
import sandbox.common.types.notification as ctn


class CheckOtherResources(sdk2.Task):
    class Parameters(sdk2.Parameters):
        service_match = sdk2.parameters.String(
            'Service name pattern.',
            description='Pattern starting from \'#\' will be interpreted as dashboard id.',
            required=True
        )
        owner_group = sdk2.parameters.String(
            'Owner group',
            default_value='BEGEMOT',
            required=True
        )
        nanny_oauth = sdk2.parameters.String(
            'Nanny oauth token',
            default_value='Begemot Nanny token',
            description='Token from https://sandbox.yandex-team.ru/admin/vault?owner={your owner group}',
            required=True
        )
        staff_oauth = sdk2.parameters.String(
            'Staff oauth token',
            default_value='Robot-begemot staff token',
            description='Token from https://sandbox.yandex-team.ru/admin/vault?owner={your owner group}',
            required=True
        )
        default_receivers = sdk2.parameters.String(
            "Staff logins of people going to receive all notifications",
            description="e.g. 'person1, person2'"
        )


    def on_execute(self):
        nanny_token = sdk2.Vault.data(self.Parameters.owner_group, self.Parameters.nanny_oauth)
        staff_token = sdk2.Vault.data(self.Parameters.owner_group, self.Parameters.staff_oauth)
        reports = cor.check_other_resources(self.Parameters.service_match,
                                            nanny_token,
                                            staff_token)
        default_receivers = [x.strip() for x in self.Parameters.default_receivers.split(',')]
        messages = cor.create_messages(reports, default_receivers, self.id)
        logging.debug(messages)
        self.set_info(cor.create_task_info(reports), do_escape=False)
        for rec, msg in messages.iteritems():
            self.server.notification(
                subject='Nanny autocheck warning: OTHER_RESOURCE in nanny service',
                body=msg,
                recipients=rec,
                transport=ctn.Transport.EMAIL,
                urgent=False,
                type='html'
            )
