# -*- coding: utf-8 -*-
from sandbox.projects.common import binary_task
import sandbox.common.types.client as ctc
import sandbox.common as common

from sandbox.projects.common.vcs.arc import Arc
import sandbox.sdk2 as sdk2
import logging
import json
import os


def _get_and_set_token(owner, secret_name):
    data = ""
    try:
        logging.debug('Getting oauth token from vault: user=%s, secret_name=%s', owner, secret_name)
        data = sdk2.Vault.data(owner, secret_name)
    except common.errors.VaultError:
        logging.debug('Unable to fetch oauth token')
    os.environ[secret_name] = data


def _set_custom_envs(owner):
    _get_and_set_token(owner, "YA_TOKEN")
    _get_and_set_token(owner, "ARC_TOKEN")
    os.environ["YA_USER"] = owner


class WebRearrFormulasBundleCommitExpFormulas(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
        Do run commit of exp formulas pack using arc and linked (peerdir) implementation in search/web/rearr_formulas_bundle/content_commiter
    """
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        disk_space = 2 * 1024
        ram = 10 * 1024
        cpu = 2

    class Parameters(sdk2.Task.Parameters):
        tasks_archive_resource = binary_task.binary_release_parameters(stable=True)
        run_options_json = sdk2.parameters.String("Json-options to run with", required=True, multiline=True)
        tokens_and_review_owner = sdk2.parameters.String("tokens_and_review_owner", default="robot-models-herder")

    class Context(sdk2.Task.Context):
        pass

    def on_execute(self):
        from . import byndings

        updated_params = json.loads(self.Parameters.run_options_json)
        updated_params["ArcBinPath"] = Arc().binary_path
        updated_params["CommiterUser"] = self.Parameters.tokens_and_review_owner
        updated_params["CommitMessageInfo"] = updated_params.get("CommitMessageInfo", " ") + (" sbTask:%s" % str(self.id))
        _set_custom_envs(self.Parameters.tokens_and_review_owner)

        byndings.DoCommitFormulas(json.dumps(updated_params))
