# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects import resource_types
from sandbox.projects.websearch.middlesearch import resources as ms_resources
from sandbox.projects.common.search import gdb


class BuildMiddlesearch2(YaMakeTemplate.YaMakeTemplate):
    """
    Build middlesearch bundle
    """
    class Requirements(sdk2.Task.Requirements):
        disk_space = 80 * 1024

    class Parameters(YaMakeTemplate.get_project_params(build_resources=[
        ms_resources.RankingMiddlesearchExecutable,
        ms_resources.L1IntsearchExecutable,
        ms_resources.IntsearchExecutable,
        resource_types.FRESH_RANKING_MIDDLESEARCH_EXECUTABLE,
        resource_types.IMAGES_MIDDLESEARCH_EXECUTABLE,
        resource_types.VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE,
        resource_types.MISC_MIDDLESEARCH_EXECUTABLE,
        resource_types.LOGANALYZE_EXECUTABLE,
        resource_types.EVLOGDUMP_EXECUTABLE,
        resource_types.EVLOGCACHEHIT_EXECUTABLE,
        resource_types.EVLOGSAMPLE_EXECUTABLE,
        ms_resources.ItditpMiddlesearchExecutable])):
        pass

    def on_execute(self):
        gdb.append_to_stable_only(self)
        super(YaMakeTemplate.YaMakeTemplate, self).on_execute()
