# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects import resource_types
from sandbox.projects.common.search import gdb


class BuildMiddlesearchVideo(YaMakeTemplate.YaMakeTemplate):
    """
    Build video middlesearch bundle
    """
    class Requirements(sdk2.Task.Requirements):
        disk_space = 80 * 1024

    class Parameters(YaMakeTemplate.get_project_params(build_resources=[
        resource_types.VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE,
        resource_types.LOGANALYZE_EXECUTABLE,
        resource_types.EVLOGDUMP_EXECUTABLE,
        resource_types.EVLOGSAMPLE_EXECUTABLE])):
        pass

    def on_execute(self):
        gdb.append_to_stable_only(self)
        super(YaMakeTemplate.YaMakeTemplate, self).on_execute()
