import jinja2
import json


def meta_search_perf_result_renderer(template_content, json_table_stat, out_file_path):
    assert isinstance(json_table_stat, dict)

    jinja_template = jinja2.Template(template_content)

    header = json_table_stat["header"]
    body = json_table_stat["body"]
    num_rows = len(body["stat"])
    for key in body:
        assert len(body[key]) == num_rows
    report = jinja_template.render(header=header, body=body, num_rows=num_rows)
    with open(out_file_path, "w") as out_file:
        out_file.write(report)


if __name__ == "__main__":
    with open('analytics_table.json') as analytics_file:
        json_table_stat = json.load(analytics_file)
    template_content = ''
    with open('./templates/diff_table.jinja2') as template_file:
        template_content = template_file.read().decode('utf-8')
    meta_search_perf_result_renderer(
        template_content=template_content,
        json_table_stat=json_table_stat,
        out_file_path='diff_results.html'
    )
