# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.BaseGetDatabaseTask import BaseGetDatabaseTask


class GetMiddlesearchDatabase(BaseGetDatabaseTask):
    """
        **Описание**

            Скачивает пользовательские данные для среднего поиска
    """
    type = 'GET_MIDDLESEARCH_DATABASE'

    execution_space = 40*1024

    @property
    def database_owner(self):
        return None  # means default owner

    @property
    def database_filename(self):
        return 'middlesearch_database'

    def _get_cms_configurations(self):
        configurations = self.ctx.get('cms_configurations')
        if configurations:
            return configurations
        else:
            return 'ASPAM', 'WEB', 'WEB_NEWDB', 'HEAD'

    def _get_ignored_files(self):
        return ['stable*']

    def _get_database_resource_type(self):
        return resource_types.MIDDLESEARCH_DATA


__Task__ = GetMiddlesearchDatabase
