# -*- coding: utf-8 -*-

import logging
import os

from sandbox import sdk2
import sandbox.projects.websearch.middlesearch.resources as ms_resources


class GetMiddlesearchProdQueries(sdk2.Task):
    """
        Task for getting middlesearch queries from YT.
    """

    class Requirements(sdk2.Requirements):
        disk_space = 10 * 1024  # 10 Gb
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        kill_timeout = 6 * 60 * 60  # 6 hours
        day = sdk2.parameters.String("Day")
        mmeta_query_limit = sdk2.parameters.Integer("Mmeta query limit", default=0)
        int_query_limit = sdk2.parameters.Integer("Int query limit", default=0)
        itditp_query_limit = sdk2.parameters.Integer("ItdItp query limit", default=0)
        add_te_attrs = sdk2.parameters.Bool("Add TE prod attrs", default=False)

    def on_execute(self):
        selected_day = self.Parameters.day.replace("_", "")
        with sdk2.environments.VirtualEnvironment() as venv:
            logging.info('Installing yql')
            sdk2.environments.PipEnvironment('yql', version="1.2.91", venv=venv, use_wheel=True).prepare()
            sdk2.environments.PipEnvironment('yandex-yt', venv=venv, use_wheel=True).prepare()
            sdk2.environments.PipEnvironment(
                'yandex-yt-yson-bindings-skynet', venv=venv, use_wheel=True
            ).prepare()
            for mtype, query_limit in self._mmeta_params():
                if query_limit > 0:
                    cgi_res = ms_resources.WebMiddlesearchPlainTextQueries(
                        self, "{} prod queries cgi {}".format(mtype, self.Parameters.day),
                        "{}_prod_queries_cgi_{}.txt".format(mtype, selected_day)
                    )
                    if self.Parameters.add_te_attrs:
                        setattr(cgi_res, "TE_web_production_{}_reqs".format(mtype), self.Parameters.day)
                    cmd = [
                        venv.executable, os.path.dirname(__file__) + '/select_middlesearch_queries.py',
                        "--day", selected_day,
                        "--mtype", mtype,
                        "--limit", str(query_limit),
                        "--token", sdk2.Vault.data(self.owner, "yt_token_for_eventlogs"),
                        "--cgipath", str(sdk2.ResourceData(cgi_res).path),
                        "--sbtaskid", str(self.id),
                    ]
                    if mtype == "mmeta" or mtype == "itditp":
                        apphost_res = ms_resources.WebMiddlesearchApphostRequests(
                            self, "{} prod queries apphost {}".format(mtype, self.Parameters.day),
                            "{}_prod_queries_apphost_{}.txt".format(mtype, selected_day)
                        )
                        if self.Parameters.add_te_attrs:
                            setattr(apphost_res, "TE_web_production_{}_reqs".format(mtype), self.Parameters.day)
                        cmd.extend(["--apphostpath", str(sdk2.ResourceData(apphost_res).path)])
                    with sdk2.helpers.ProcessLog(self, logger="select_{}_queries".format(mtype)) as pl:
                        sdk2.helpers.subprocess.check_call(" ".join(cmd), shell=True, stdout=pl.stdout, stderr=pl.stderr)

    def _mmeta_params(self):
        return [
            ("mmeta", self.Parameters.mmeta_query_limit),
            ("int", self.Parameters.int_query_limit),
            ("itditp", self.Parameters.itditp_query_limit),
        ]
