import logging
import shutil

from sandbox import sdk2

import sandbox.projects.common.search.components.mkl as sc_mkl
import sandbox.projects.common.search.bugbanner2 as bb2
import sandbox.projects.websearch.middlesearch.base_tasks.multi_host_task as ms_multi_host
from sandbox.projects import resource_types


class GetWebMiddlesearchResponsesMultiHost(ms_multi_host.WebMiddlesearchMultiHost):
    """
       Task for getting responses from local web middlesearch with global basesearches
    """

    def on_execute(self):
        self.add_bugbanner(bb2.Banners.WebMiddleSearch)
        wms = self.init_searchers()
        sc_mkl.configure_mkl_environment(wms)
        output_res = self.output_responses()
        with wms:
            logging.info("Launch %s", wms.name)
            self.save_responses(
                wms.apphost_port,
                str(sdk2.ResourceData(output_res).path),
            )
        if self.Parameters.middlesearch.save_eventlog:
            evlog = resource_types.EVENTLOG_DUMP(
                self, "Middlesearch eventlog, {}".format(self.Parameters.description.encode("utf-8")),
                "middlesearch_event.log"
            )
            shutil.move(wms.path_to_log("event"), str(evlog.path))

    def output_responses(self):
        if self.Parameters.make_binary:
            return resource_types.SEARCH_PROTO_RESPONSES(
                self, "Middlesearch responses, {}".format(self.Parameters.description.encode("utf-8")),
                "middlesearch_responses.bin"
            )
        else:
            return resource_types.BASESEARCH_HR_RESPONSES(
                self, "Middlesearch responses, {}".format(self.Parameters.description.encode("utf-8")),
                "middlesearch_responses.txt"
            )
