import logging
import shutil

from sandbox import sdk2

import sandbox.projects.common.search.components.mkl as sc_mkl
import sandbox.projects.common.search.bugbanner2 as bb2
import sandbox.projects.websearch.middlesearch.base_tasks.multi_host_task as ms_multi_host
from sandbox.projects import resource_types


class GetWebMiddlesearchResponsesMultiHostParallel(ms_multi_host.WebMiddlesearchMultiHost):
    """
       Task for getting responses in parallel from local web middlesearch with global basesearches
    """

    def on_execute(self):
        self.add_bugbanner(bb2.Banners.WebMiddleSearch)
        wms1, wms2 = self.init_searchers()
        sc_mkl.configure_mkl_environment(wms1)
        sc_mkl.configure_mkl_environment(wms2)
        output_res1 = self.output_responses(1)
        output_res2 = self.output_responses(2)
        with wms1, wms2:
            logging.info("Launch %s and %s", wms1.name, wms2.name)
            self.save_responses(
                wms1.apphost_port,
                str(sdk2.ResourceData(output_res1).path),
            )
            self.save_responses(
                wms2.apphost_port,
                str(sdk2.ResourceData(output_res2).path),
            )
        if self.Parameters.middlesearch.ms_save_eventlog1:
            evlog = resource_types.EVENTLOG_DUMP(
                self, "Middlesearch 1 eventlog, {}".format(self.Parameters.description.encode("utf-8")),
                "middlesearch_1_event.log"
            )
            shutil.move(wms1.path_to_log("event"), str(evlog.path))
        if self.Parameters.middlesearch.ms_save_eventlog2:
            evlog = resource_types.EVENTLOG_DUMP(
                self, "Middlesearch 2 eventlog, {}".format(self.Parameters.description.encode("utf-8")),
                "middlesearch_2_event.log"
            )
            shutil.move(wms2.path_to_log("event"), str(evlog.path))

    def output_responses(self, suffix):
        if self.Parameters.make_binary:
            return resource_types.SEARCH_PROTO_RESPONSES(
                self, "Middlesearch {} responses, {}".format(suffix, self.Parameters.description.encode("utf-8")),
                "middlesearch_responses.bin"
            )
        else:
            return resource_types.BASESEARCH_HR_RESPONSES(
                self, "Middlesearch {} responses, {}".format(suffix, self.Parameters.description.encode("utf-8")),
                "middlesearch_responses.txt"
            )
