# -*- coding: utf-8 -*-

from sandbox.projects.websearch.middlesearch.TestMiddlesearchSingleHost import TestMiddlesearchSingleHost
from sandbox.projects.common import sanitizer
from sandbox.projects.common.search import components as sc

LeakSanitized = sanitizer.generate_task(
    sc.DefaultMiddlesearchParams,
    TestMiddlesearchSingleHost,
    start_timeout=sc.DEFAULT_START_TIMEOUT * 2
)


class SanitizeMiddlesearch(LeakSanitized):
    """
        Запускает долбёжку метапоиска (собранного с Leak Sanitizer) на производительность (типа, stress test).
        Тюнит некоторые параметры конфига, чтобы побыстрее стартовало. Смотрит, упадёт или нет.
    """
    type = 'SANITIZE_MIDDLESEARCH'
    execution_space = 120 * 1024  # 120G
    required_ram = 180 * 1024 # 180G


__Task__ = SanitizeMiddlesearch
