from sandbox.projects.common.search.response import cgi

insignificant_params = ['timeout', 'ruid', 'req_path', 'REASK']


class Request(object):
    def __init__(self, request):
        self.reqid = ''
        self.is_reask = False
        self.cgi_params = {}
        for key, value in cgi.split_to_cgi(request, url=True):
            if key == 'REASK':
                self.is_reask = True
            if key not in insignificant_params:
                self.cgi_params.setdefault(key, []).append(value)
            if key == 'reqid':
                self.reqid = value

    def __str__(self):
        return '&'.join(
            map(
                lambda key, vals: '&'.join(map(lambda val: '{}={}'.format(key, val), vals)),
                self.cgi_params.items()
            )
        )


def diff_requests(l, r):
    diff = {}
    absent = {}
    extra = {}
    for key, val in l.items():
        if key in r:
            plus = set(r[key]) - set(val)
            minus = set(val) - set(r[key])
            if len(plus) or len(minus):
                diff[key] = (list(plus), list(minus))
        else:
            absent[key] = val
    for key, val in r.items():
        if key not in l:
            extra[key] = val
    result = (diff, absent, extra)
    return any(result), result
