import sandbox.projects.common.search.yasm as search_yasm
import sandbox.projects.websearch.middlesearch.TestMiddlesearchSingleHost as tmsh
from sandbox.projects import resource_types

_INSTANCE_TYPE = "mmeta"
_INSTANCE_TAG = (
    ("ctype", "prod"),
    ("geo", "man"),
    ("prj", "web-main"),
    ("tier", "yandsearch"),
)


class WebTestMiddlesearchUnistat(tmsh.TestMiddlesearchSingleHost, search_yasm.YasmAgentTask):
    """
        Verify unistat implementation in web middlesearch
    """
    input_parameters = tmsh.TestMiddlesearchSingleHost.input_parameters + search_yasm.YasmAgentTask.input_parameters
    type = 'WEB_TEST_MIDDLESEARCH_UNISTAT'

    def on_enqueue(self):
        tmsh.TestMiddlesearchSingleHost.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            resource_types.BASESEARCH_UNISTAT_SIGNALS,
        )

    def _use_middlesearch_component(self, wms):
        yasmagent = self._yasmagent(wms, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        with yasmagent, yasmlistener:
            tmsh.TestMiddlesearchSingleHost._use_middlesearch_component(self, wms)
        yasmlistener.dump(self.__unistat_signals())

    def _set_yasm_config_options(self, config_object):
        config_object.set("options_unistat", "url", "/tass?level=1&allholes=1")
        config_object.set("options_unistat", "max_sig_count", 7000)

    def __unistat_signals(self):
        return self.abs_path("middlesearch-unistat-signals.txt")
