import copy

import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.environments as sdkenv
from sandbox import sdk2

import sandbox.projects.common.search.components as sc
import sandbox.projects.common.search.response.diff.protodiff as p_diff
import sandbox.projects.websearch.middlesearch.base_tasks.params as ms_params
import sandbox.projects.websearch.middlesearch.base_tasks.components as ms_comp
import sandbox.projects.websearch.middlesearch.base_tasks.middlesearch_requester_task as ms_requester


class PatchedMiddlesearchConfig(sdk2.Resource):
    """Patched middlesearch config"""


class WebMiddlesearchMultiHost(ms_requester.WebMiddlesearchRequester):
    """
       Base task for middlesearch multi host construction.
       Means not patched SearchSource etc. in middlesearch configs
    """

    class Requirements(sdk2.Task.Requirements):
        ram = 60 * 1024  # 60 Gb
        disk_space = 75 * 1024  # 75 Gb
        client_tags = ctc.Tag.GENERIC
        environments = (sdkenv.PipEnvironment('protobuf', '2.6.1', use_wheel=True),)

    class Parameters(ms_requester.WebMiddlesearchRequester.Parameters):
        head_param = sdk2.parameters.Group("Web middlesearch multi host parameters")
        middlesearch = ms_params.SingleMiddlesearchParametersAutoselect

    def init_searchers(self, need_warmup=True):
        wms = ms_comp.WebMiddlesearch(
            self,
            binary=self.Parameters.middlesearch.executable,
            basesearches=self._get_basesearchers(),
            config=self.Parameters.middlesearch.config,
            models=self.Parameters.middlesearch.models_archive,
            rearr=self.Parameters.middlesearch.rearr,
            cfg_patch_dict=self.patch_for_middlesearch_config(),
            eventlog_path=self._get_eventlog_path(),
            patched_config_resource=self._get_patched_config_resource(),
            need_warmup=need_warmup
        )
        return wms

    def _get_basesearchers(self):
        return None

    def _get_patched_config_resource(self):
        return PatchedMiddlesearchConfig(self, "Patched middlesearch config", "patched_config.cfg")

    def patch_for_middlesearch_config(self):
        ms_cfg = {}
        if self.Parameters.middlesearch.max_snippets_per_request:
            ms_cfg['Collection.MaxSnippetsPerRequest'] = self.Parameters.middlesearch.max_snippets_per_request
        if self.Parameters.middlesearch.sending_timeout is not None:  # todo: validate correctness
            ms_cfg['Collection.SendingTimeout'] = self.Parameters.middlesearch.sending_timeout
        if self.Parameters.middlesearch.n_groups_for_source_mult:
            ms_cfg['Collection.NGroupsForSourceMultiplier'] = self.Parameters.middlesearch.n_groups_for_source_mult
        return ms_cfg

    @staticmethod
    def skip_fields_in_stability_check():
        skip = copy.deepcopy(p_diff.DEFAULT_SKIP_FIELDS)
        skip["SearcherProp"][p_diff.Statement.MATCH].append("SearchErrors.debug")
        skip["GtaRelatedAttribute"][p_diff.Statement.MATCH].append("_CompressedAllFactors")
        return None


class WebMiddlesearchMultiHostParallel(WebMiddlesearchMultiHost):
    class Requirements(sdk2.Task.Requirements):
        ram = 90 * 1024  # 90 Gb
        disk_space = 120 * 1024  # 120 Gb
        client_tags = ctc.Tag.GENERIC
        environments = (sdkenv.PipEnvironment('protobuf', '2.6.1', use_wheel=True),)

    class Parameters(ms_requester.WebMiddlesearchRequester.Parameters):
        head_param = sdk2.parameters.Group("Web middlesearch multi host parameters")
        middlesearch = ms_params.DoubleMiddlesearchParameters

    def init_searchers(self):
        wms1 = ms_comp.WebMiddlesearch(
            self,
            binary=self.Parameters.middlesearch.ms_executable1,
            config=self.Parameters.middlesearch.ms_config1,
            models=self.Parameters.middlesearch.ms_models_archive1,
            rearr=self.Parameters.middlesearch.ms_rearr1,
            cfg_patch_dict=self.patch_for_middlesearch_config()
        )
        wms2 = ms_comp.WebMiddlesearch(
            self,
            binary=self.Parameters.middlesearch.ms_executable2,
            config=self.Parameters.middlesearch.ms_config2,
            models=self.Parameters.middlesearch.ms_models_archive2,
            rearr=self.Parameters.middlesearch.ms_rearr2,
            cfg_patch_dict=self.patch_for_middlesearch_config(),
            port=sc.DEFAULT_MIDDLESEARCH_PORT + 1,
        )
        return wms1, wms2
