from sandbox import sdk2

from sandbox.projects import resource_types
from sandbox.projects.websearch.params import ResourceWithDefaultByAttr
from sandbox.projects.websearch.middlesearch import resources as ms_resources
from sandbox.projects.common.search import settings as cs_settings


def middlesearch_executable(suffix=""):
    return sdk2.parameters.LastReleasedResource(
        "Middlesearch executable" + suffix,
        resource_type=ms_resources.RankingMiddlesearchExecutable,
        required=False,
    )


def middlesearch_config(suffix=""):
    return ResourceWithDefaultByAttr(
        "Middlesearch config" + suffix,
        resource_type=resource_types.MIDDLESEARCH_CONFIG,
        default_attr_name=cs_settings.WebSettings.testenv_middle_cfg_attr_name(
            middle_type="jupiter_mmeta",
            hamster_cfg=True,
        ),
    )


def middlesearch_models_archive(suffix=""):
    return sdk2.parameters.LastReleasedResource(
        "Middlesearch models archive" + suffix,
        resource_type=resource_types.DYNAMIC_MODELS_ARCHIVE,
        required=False,
    )


def middlesearch_data(suffix=""):
    return ResourceWithDefaultByAttr(
        "Middlesearch data" + suffix,
        resource_type=resource_types.MIDDLESEARCH_DATA,
        default_attr_name="TE_web_production_mmeta_data",
    )


def evlogdump_executable(suffix=""):
    return sdk2.parameters.LastReleasedResource(
        "Evlogdump executable " + suffix,
        resource_type=resource_types.EVLOGDUMP_EXECUTABLE,
        required=False
    )


SUFFIX1, SUFFIX2 = " 1", " 2"


class SingleMiddlesearchParametersAutoselect(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Web middlesearch config patch parameters") as cfg_patch_params:
        max_snippets_per_request = sdk2.parameters.Integer(
            "Max snippets per request (0 = don't change)", required=False, default=0
        )
        sending_timeout = sdk2.parameters.String("Set SendingTimeout (e.g 100ms) (see SEARCH-988)")
        n_groups_for_source_mult = sdk2.parameters.Integer(
            "Set NGroupsForSourceMultiplier to (0 = don't change)", required=False, default=5
        )
    with sdk2.parameters.Group("Web middlesearch parameters") as web_middlesearch_params:
        executable = middlesearch_executable()
        config = middlesearch_config()
        models_archive = middlesearch_models_archive()
        rearr = middlesearch_data()
        save_eventlog = sdk2.parameters.Bool("Save eventlog", default=False)
        evlogdump_exec = evlogdump_executable()


class SingleMiddlesearchParametersOptional(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Web middlesearch config patch parameters") as cfg_patch_params:
        max_snippets_per_request = sdk2.parameters.Integer(
            "Max snippets per request (0 = do not change)", required=False, default=0
        )
        sending_timeout = sdk2.parameters.String("Set SendingTimeout (e.g 100ms) (see SEARCH-988)")
        n_groups_for_source_mult = sdk2.parameters.Integer(
            "Set NGroupsForSourceMultiplier to (0 = do not change)", required=False, default=5
        )
    with sdk2.parameters.Group("Web middlesearch parameters") as web_middlesearch_params:
        executable = sdk2.parameters.Resource(
            "Middlesearch executable",
            resource_type=ms_resources.RankingMiddlesearchExecutable,
            required=False,
        )
        config = sdk2.parameters.Resource(
            "Middlesearch config",
            resource_type=resource_types.MIDDLESEARCH_CONFIG,
            required=False,
        )
        models_archive = sdk2.parameters.Resource(
            "Middlesearch models archive",
            resource_type=resource_types.DYNAMIC_MODELS_ARCHIVE,
            required=False,
        )
        data = sdk2.parameters.Resource(
            "Middlesearch data",
            resource_type=resource_types.MIDDLESEARCH_DATA,
            required=False,
        )
        save_event_log = sdk2.parameters.Bool("Save event log", default=False)


class DoubleMiddlesearchParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Web middlesearch config patch parameters") as cfg_patch_params:
        max_snippets_per_request = sdk2.parameters.Integer(
            "Max snippets per request (0 = don't change)", required=False, default=0
        )
        sending_timeout = sdk2.parameters.String("Set SendingTimeout (e.g 100ms) (see SEARCH-988)")
        n_groups_for_source_mult = sdk2.parameters.Integer(
            "Set NGroupsForSourceMultiplier to (0 = don't change)", required=False, default=5
        )
    with sdk2.parameters.Group("Web middlesearch parameters" + SUFFIX1) as web_middlesearch_params1:
        ms_executable1 = middlesearch_executable(SUFFIX1)
        ms_config1 = middlesearch_config(SUFFIX1)
        ms_models_archive1 = middlesearch_models_archive(SUFFIX1)
        ms_rearr1 = middlesearch_data(SUFFIX1)
        ms_save_eventlog1 = sdk2.parameters.Bool("Save eventlog" + SUFFIX1, default=False)

    with sdk2.parameters.Group("Web middlesearch parameters" + SUFFIX2) as web_middlesearch_params2:
        ms_executable2 = middlesearch_executable(SUFFIX2)
        ms_config2 = middlesearch_config(SUFFIX2)
        ms_models_archive2 = middlesearch_models_archive(SUFFIX2)
        ms_rearr2 = middlesearch_data(SUFFIX2)
        ms_save_eventlog2 = sdk2.parameters.Bool("Save eventlog" + SUFFIX2, default=False)
