import sandbox.common.types.client as ctc
from sandbox import sdk2

import sandbox.projects.common.search.components as sc
import sandbox.projects.websearch.basesearch.components as bs_comp
import sandbox.projects.websearch.basesearch.params as bs_params
import sandbox.projects.websearch.middlesearch.base_tasks.components as ms_comp
import sandbox.projects.websearch.middlesearch.base_tasks.middlesearch_requester_task as ms_requester
import sandbox.projects.websearch.middlesearch.base_tasks.params as ms_params


class WebMiddlesearchSingleHost(ms_requester.WebMiddlesearchRequester):
    """
       Base task for middlesearch single host construction
    """
    class Requirements(sdk2.Task.Requirements):
        ram = 60 * 1024  # 60 Gb
        disk_space = 115 * 1024  # 115 Gb
        client_tags = ctc.Tag.GENERIC

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(ms_requester.WebMiddlesearchRequester.Parameters):
        head_param = sdk2.parameters.Group("Web middlesearch single host parameters")
        middlesearch = ms_params.SingleMiddlesearchParametersAutoselect
        basesearch = bs_params.DoubleBasesearchParameters

    def init_single_host_searchers(self):
        wbs1 = bs_comp.WebBasesearch(
            self,
            binary=self.Parameters.basesearch.executable1,
            config=self.Parameters.basesearch.config1,
            models=self.Parameters.basesearch.models_archive1,
            database=self.Parameters.basesearch.database1,
            polite_mode=self.Parameters.basesearch.polite_mode1,
            # patch_request_threads=self.Parameters.basesearch.patch_request_threads1,
        )
        wbs2 = bs_comp.WebBasesearch(
            self,
            binary=self.Parameters.basesearch.executable2,
            config=self.Parameters.basesearch.config2,
            models=self.Parameters.basesearch.models_archive2,
            database=self.Parameters.basesearch.database2,
            port=sc.DEFAULT_BASESEARCH_PORT + 1,
            polite_mode=self.Parameters.basesearch.polite_mode2,
            # patch_request_threads=self.Parameters.basesearch.patch_request_threads2,
        )
        wms = ms_comp.WebMiddlesearch(
            self,
            binary=self.Parameters.middlesearch.executable,
            config=self.Parameters.middlesearch.config,
            models=self.Parameters.middlesearch.models_archive,
            rearr=self.Parameters.middlesearch.rearr,
            basesearches=[
                # Use same instances, see SEARCH-1022 for details (production-alike)
                {
                    'basesearch_type': "PLATINUM",
                    'searchers': [('localhost', wbs1.port)] * 3,
                },
                {
                    'basesearch_type': "WEB",
                    'searchers': [('localhost', wbs2.port)] * 3,
                }
            ],
            cfg_patch_dict=self.patch_for_middlesearch_config(),
            eventlog_path=self._get_eventlog_path()
        )
        return wbs1, wbs2, wms

    def patch_for_middlesearch_config(self):
        ms_cfg = {}
        if self.Parameters.middlesearch.max_snippets_per_request:
            ms_cfg['Collection.MaxSnippetsPerRequest'] = self.Parameters.middlesearch.max_snippets_per_request
        if self.Parameters.middlesearch.sending_timeout is not None:  # todo: validate correctness
            ms_cfg['Collection.SendingTimeout'] = self.Parameters.middlesearch.sending_timeout
        if self.Parameters.middlesearch.n_groups_for_source_mult:
            ms_cfg['Collection.NGroupsForSourceMultiplier'] = self.Parameters.middlesearch.n_groups_for_source_mult
        return ms_cfg
