from sandbox import sdk2
from sandbox.common.types import resource as ctr
import sandbox.projects.resource_types.releasers as rr
import sandbox.projects.resource_types as resource_types


class WebMiddlesearchApphostRequests(sdk2.Resource):
    """
       Web middlesearch apphost request contexts (base64 encoded)
    """
    auto_backup = True
    TE_web_production_mmeta_reqs = sdk2.parameters.String("Time yyyy_mm_dd")
    TE_web_production_itditp_reqs = sdk2.parameters.String("Time yyyy_mm_dd")


class WebMiddlesearchPlainTextQueries(sdk2.resource.AbstractResource):
    """
        CGI-queries for web metasearch as plain text file (1 query on string)
        Each query should begin from "?". Host/port should not be specified
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class WebMiddlesearchExecutableFuzzy(sdk2.resource.AbstractResource):
    """
        Fuzzer web middlesearch executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/fuzzing/fuzz_ranking_meta/fuzz_ranking_meta'
    arcadia_build_name = 'ranking_middlesearch_fuzzy'


class MiddlesearchPlan(sdk2.resource.AbstractResource):
    """
        Dolbilka plan with queries to middle search
    """
    auto_backup = True


class ItditpMiddlesearchExecutable(sdk2.Resource):
    """
        Build ItdItp middle search
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_itditp_middlesearch/ranking_itditp_middlesearch'
    arcadia_build_name = 'ranking_itditp_middlesearch'


class L1IntsearchExecutable(sdk2.Resource):
    """
        L1 Intsearch executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.unique_list(rr.middle_releasers + rr.base_releasers)
    arcadia_build_path = 'search/daemons/l1_intsearch/l1_intsearch'
    arcadia_build_name = 'intsearch'


class RankingMiddlesearchExecutable(resource_types.AbstractResource):
    """
        Ranking middlesearch executable for web
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_types.resource_releasers.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/ranking_middlesearch'
    arcadia_build_name = 'ranking_middlesearch'


class IntsearchExecutable(resource_types.AbstractResource):
    """
        Intsearch executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.unique_list(rr.middle_releasers + rr.base_releasers)
    arcadia_build_path = 'search/daemons/intsearch/intsearch'
    arcadia_build_name = 'intsearch'


class RankingMiddlesearchProductionLoopConf(sdk2.resource.Resource):
    """
        Ranking middlesearch loop.conf file for production
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'production_loop.conf'


class RankingMiddlesearchHamsterLoopConf(sdk2.resource.Resource):
    """
        Ranking middlesearch loop.conf file for hamster
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'hamster_loop.conf'


class RankingMiddlesearchHeaterLoopConf(sdk2.resource.Resource):
    """
        Ranking middlesearch loop.conf file for cache heater
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'heater_loop.conf'


class RankingMiddlesearchItditpLoopConf(sdk2.resource.Resource):
    """
        Ranking middlesearch loop.conf file for itditp
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'itditp_loop.conf'


class RankingMiddlesearchProductionUnifiedAgentConf(sdk2.resource.Resource):
    """
        Ranking middlesearch unified_agent.conf file for production
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'production_unified_agent.conf'


class RankingMiddlesearchHamsterUnifiedAgentConf(sdk2.resource.Resource):
    """
        Ranking middlesearch unified_agent.conf file for hamster
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.middle_releasers
    arcadia_build_path = 'search/daemons/ranking_middlesearch/configs'
    config_name = 'hamster_unified_agent.conf'


meta_executable_res_types = [
    RankingMiddlesearchExecutable,
    resource_types.FRESH_RANKING_MIDDLESEARCH_EXECUTABLE,
    resource_types.IMAGES_MIDDLESEARCH_EXECUTABLE,
    resource_types.VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE,
    resource_types.MISC_MIDDLESEARCH_EXECUTABLE,
    L1IntsearchExecutable
]
