from sandbox.common.utils import Enum


class ServiceType(Enum):
    RTMODELS = "rtmodels"
    CFG_MODELS = "cfg_models"


def get_service_type(service):
    if service in {
        "sas_mmeta_runtime_models",
        "man_mmeta_runtime_models",
        "vla_mmeta_runtime_models",
        "sas_mmeta_runtime_models_hamster",
        "man_mmeta_runtime_models_hamster",
        "vla_mmeta_runtime_models_hamster",
    }:
        return ServiceType.RTMODELS
    elif service in {
        "sas_mmeta_cfg_models",
        "man_mmeta_cfg_models",
        "vla_mmeta_cfg_models",
        "sas_mmeta_cfg_models_hamster",
        "man_mmeta_cfg_models_hamster",
        "vla_mmeta_cfg_models_hamster",
        "man_mmeta_cfg_models_priemka",
    }:
        return ServiceType.CFG_MODELS
    assert False, "Can't determine service type for %s" % service
