import sandbox.common.utils
from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.common.types import resource as ctr
from sandbox.projects.common import resource_selectors


class ResourceWithDefaultByAttr(sdk2.parameters.Resource):
    """
        Resource selector parameter defaults to resource with specified attr_name and highest attr_value
    """
    required = False

    @property
    def default_attr_name(self):
        raise NotImplementedError("Default attr name is not specified")

    @sandbox.common.utils.classproperty
    def default_value(cls):
        res_type = cls._get_resource_types()[0]
        return resource_selectors.by_max_attr_value(res_type, cls.default_attr_name)


class ResourceWithLastReleasedValueByDefault(sdk2.parameters.Resource):
    """
        Resource selector parameter defaults to last released resource
    """

    @sandbox.common.utils.classproperty
    def default_value(cls):
        resources = sdk2.Task.server.resource.read(
            type=cls.resource_type,
            status=ctr.State.READY,
            attrs={"released": ctt.ReleaseStatus.STABLE},
            limit=10,
        )["items"]
        if resources:
            return max(resources, key=lambda resource: sdk2.Task[resource["task"]["id"]].updated)["id"]
        return None
