from sandbox import sdk2


sdch_releasers = [
    'robot-nirvana',
    'amosov-f',
    'inikifor',
    'kormyshov',
    'robot-trencher',
    'andre487',
    'log1n',
    'yeremeyev',
    'feldsherov'
]


class SdchEncoderExecutable(sdk2.Resource):
    """
        search/sdch/daemon executable
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = sdch_releasers
    arcadia_build_path = 'search/sdch/daemon/daemon'


class SdchReleaseConfig(sdk2.Resource):
    """
        sdch two phase release config
        that is json with schema from
        https://a.yandex-team.ru/arc/trunk/arcadia/search/sdch/daemon/config.proto
    """
    releasable = True
    executable = False
    auto_backup = True
    releasers = sdch_releasers
