import os

import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.svn as svn
from sandbox import sdk2
from sandbox.projects.common import file_utils as fu

ARCADIA_URL = "arcadia:/arc/trunk/arcadia/"
TUNNELLER_CONTAINER_PATH = "search/tunneller/libs/restrict_profile_container"
PROFILES_PATH = "arcadia:/arc/trunk/arcadia/search/scraper/profile"
PROFILE_PREFIX = "PROFILE_RESOURCE_PREFIX_"


def build_make_file(profiles):
    make = "LIBRARY()\nOWNER(g:tunneller)\nPEERDIR(\n\tlibrary/cpp/deprecated/split\n\tlibrary/cpp/json\n\tlibrary/cpp/resource\n)\nSRCS(\n\trestrict_profile_container.cpp\n\trestrict_profile.cpp\n)\nGENERATE_ENUM_SERIALIZATION(threshold_type.h)\nRESOURCE(\n"
    for profile, profile_name in profiles:
        make += "\tsearch/scraper/profile/{profile} {profile_name}\n".format(profile=profile, profile_name=PROFILE_PREFIX + profile_name)
    make += "\n\tsearch/scraper/master_profile/master_profile.json PROFILE_RESOURCE_PREFIX_master_profile\n)\nEND()\n"
    return make.replace("\t", " " * 4)


class PatchProfilesMakeFile(sdk2.Task):
    execution_space = 1000

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    def on_execute(self):
        local_path = os.path.abspath("ya_make")
        svn.Arcadia.checkout(ARCADIA_URL + TUNNELLER_CONTAINER_PATH, local_path)

        profiles = []
        for profile in svn.Arcadia.list(PROFILES_PATH, as_list=True):
            if profile.endswith(".json"):
                profile_name = profile.split('/')[-1]

                profiles += [[profile, profile_name.split('.')[0]]]

        fu.write_file(local_path + "/ya.make", build_make_file(profiles))

        svn.Arcadia.commit(
            local_path,
            "updated tunneller's container SKIP_CHECK",
            user="zomb-sandbox-rw"
        )
