# -*- coding: utf-8 -*-
from sandbox.projects import resource_types

import sandbox.sandboxsdk.parameters as sb_params
import sandbox.sdk2.parameters as parameters
import sandbox.projects.common.search.gdb as gdb
import sandbox.projects.common.constants as consts
import sandbox.projects.release_machine.mixins.build as rm_build_mixin

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine import rm_notify
from sandbox.projects.release_machine.components.configs.upper import UpperCfg
from sandbox.projects.websearch import release_setup
from sandbox.projects.websearch.upper import resources as upper_resources


from sandbox.yasandbox import manager


class ClearBuild(sb_params.SandboxBoolParameter):
    name = consts.CLEAR_BUILD_KEY
    description = 'Clear build'
    default_value = False
    group = 'Base build params'


class BuildSystem(parameters.String):
    name = consts.BUILD_SYSTEM_KEY
    description = 'Build system'
    required = True
    default_value = consts.SEMI_DISTBUILD_BUILD_SYSTEM
    group = 'Build system params'
    choices = [
        ('Ya', consts.YMAKE_BUILD_SYSTEM),
        # TODO: remove after experiments
        ('Ya force', consts.YA_MAKE_FORCE_BUILD_SYSTEM),
        ('semi-distbuild', consts.SEMI_DISTBUILD_BUILD_SYSTEM),
        ('distbuild', consts.DISTBUILD_BUILD_SYSTEM),
    ]
    sub_fields = {
        consts.YMAKE_BUILD_SYSTEM: [consts.TARGET_PLATFORM_KEY],
        consts.YA_MAKE_FORCE_BUILD_SYSTEM: [consts.TARGET_PLATFORM_KEY],
    }


@rm_notify.notify2()
class BuildNoapacheUpper(rm_build_mixin.ComponentReleaseTemplate, CommonBuildTask, nanny.ReleaseToNannyTask):
    """
        Build noapacheupper
    """

    type = 'BUILD_NOAPACHE_UPPER'

    execution_space = 80000  # 80 Gb, detected 69.2GB

    client_tags = release_setup.WEBSEARCH_TAGS_P0
    input_parameters = [
        ClearBuild,
        BuildSystem,
    ] + [
        k for k in CommonBuildTask.input_parameters
        if k.name != "clear_build" and k.name != "build_system"
    ] + build_params.get_check_deps_params()

    TARGET_RESOURCES = (
        (upper_resources.NoapacheUpper, 'search/daemons/noapacheupper/noapacheupper'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'search/tools/evlogdump/evlogdump'),
        (resource_types.APP_HOST_TOOL_CONVERTER_EXECUTABLE, 'apphost/tools/converter/converter'),
    )

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            decreased_space = 32 * 1024
            if decreased_space < self.execution_space:
                self.execution_space = decreased_space  # Decrease trunk build execution space
        self.ctx[rm_const.COMPONENT_CTX_KEY] = UpperCfg.name
        CommonBuildTask.on_enqueue(self)

    def do_execute(self):
        gdb.append_to_stable_only(self)
        CommonBuildTask.do_execute(self)

    def on_release(self, additional_parameters):
        # FIXME(mvel) a bit of copypaste here
        if nanny.STARTREK_TICKET_IDS_KEY in additional_parameters:
            self.ctx[nanny.STARTREK_TICKET_IDS_KEY] = additional_parameters[nanny.STARTREK_TICKET_IDS_KEY]

        # to filter evlogdumps built with stable noapache
        evlogdump_resource = self.list_resources(resource_types.EVLOGDUMP_EXECUTABLE)[0]
        evlogdump_resource.attrs['service'] = 'noapache'
        manager.resource_manager.update(evlogdump_resource)

        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildNoapacheUpper
