# coding: utf-8

import os
import logging

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as bp

from sandbox.projects.common.noapacheupper import build as nb
from sandbox.projects.websearch import release_setup

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.svn import Arcadia


class Params:
    # class RearrangeSvnUrl(parameters.SandboxArcadiaUrlParameter):
    #    name = "rearrange_svn_url"
    #    description = "Svn url for branch with rearrange data"
    #    default_value = "arcadia:/arc/trunk"
    #    required = True

    class CustomBuildSystem(parameters.SandboxStringParameter):
        name = 'custom_build_system'
        description = "Custom build system i.e. ya, ya_force or distbuild_force"
        default_value = 'ya'

    params = (
        CustomBuildSystem,
        # RearrangeSvnUrl,
        nb.Params.UseArchiver,
        nb.Params.ExtensionsToArchive,
        bp.ArcadiaUrl,
        bp.ArcadiaPatch,
        bp.CheckoutModeParameter,
        bp.CheckoutParameter,
        bp.UseArcadiaApiFuse,
        bp.AllowArcadiaApiFallback,
    )


class BuildNoapacheupperData(YaMakeTask):
    """
        Сборка данных для тестов noapacheupper/blender (верхнего метапоиска) из svn
        (переранжирования + динамические переранжирования + быстрые данные)
    """
    type = "BUILD_NOAPACHEUPPER_DATA"

    input_parameters = Params.params
    execution_space = 100 * 1024  # 93G delta detected
    client_tags = release_setup.WEBSEARCH_TAGS_P0
    cores = 24

    data_dir = None

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx['build_system'] = self.ctx['custom_build_system']

    def on_enqueue(self):
        YaMakeTask.on_enqueue(self)
        self.ctx['build_system'] = self.ctx['custom_build_system']
        # if self.ctx['build_system'] == constants.DISTBUILD_FORCE_BUILD_SYSTEM:
        #    self.execution_space = 15 * 1024  # distbuild allows this magic (or it isn't wtf)
        # very important command, see yetty's letter
        channel.task = self
        self.ctx["out_resource_id"] = self.create_resource(
            self.descr,
            "data",
            resource_types.NOAPACHEUPPER_DATA,
            attributes={
                "ttl": 90,
            },
            arch="any",
        ).id

    def on_execute(self):
        data_dir = self.abs_path("data")
        if not os.path.isdir(data_dir):
            os.mkdir(data_dir)

        self.data_dir = data_dir
        nb.calculate_targets(self)
        YaMakeTask.on_execute(self)

    def post_build(self, source_dir, output_dir, pack_dir):
        log_even_files(output_dir)
        YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)

        rearrange_dynamic_dir = os.path.join(self.data_dir, 'rearrange.dynamic/')
        log_even_files(output_dir)
        nb.export_ya_make_result(
            os.path.join(output_dir, 'search/web/rearrs_upper/rearrange.dynamic/'),
            rearrange_dynamic_dir,
        )
        log_even_files(output_dir)
        nb.archive(self, rearrange_dynamic_dir, output_dir)
        log_even_files(output_dir)
        self.ctx["rearrange.dynamic_size"] = nb.get_directory_size(rearrange_dynamic_dir)

        rearrange_data_dir = os.path.join(self.data_dir, 'rearrange/')
        log_even_files(output_dir)
        nb.export_ya_make_result(
            os.path.join(output_dir, 'search/web/rearrs_upper/rearrange/'),
            rearrange_data_dir,
        )
        log_even_files(output_dir)
        self.ctx["rearrange_size"] = nb.get_directory_size(rearrange_data_dir)

        rearrange_data_fast_dir = os.path.join(self.data_dir, 'rearrange.fast/')
        log_even_files(output_dir)
        nb.export_ya_make_result(
            os.path.join(output_dir, 'search/web/rearrs_upper/rearrange.fast/'),
            rearrange_data_fast_dir,
        )
        log_even_files(output_dir)
        self.ctx["rearrange.fast_size"] = nb.get_directory_size(rearrange_data_fast_dir)


def svn_subfolder_url(svn_url, subfolder):
    svn_info = Arcadia.info(svn_url)
    return "{}/{}@{}".format(svn_info["url"], subfolder, svn_info["entry_revision"])


def log_even_files(path):
    try:
        res = []
        for root, directories, filenames in os.walk(path):
            for filename in filenames:
                name = os.path.join(root, filename)
                size = os.path.getsize(name)
                if size % 2 ** 11 == 0:
                    logging.debug("%s %s", size, name)
                    res.append((size, name))
        logging.debug(len(res))
    except Exception:
        pass


__Task__ = BuildNoapacheupperData
