# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common.noapacheupper import request
from sandbox.projects.common.noapacheupper.search_component import Params as NoapacheupperParams
from sandbox.projects.common.noapacheupper.standalone import ResponsesStandaloneNoapacheupper2
from sandbox.projects.common.noapacheupper.standalone import RunMode


class BuildNoapacheupperNehCache(ResponsesStandaloneNoapacheupper2):
    """
        Генератор neh cache (закешированных ответов с источников), - поднимает безапачевый верхний используя
        поправленную версию предоставленнго конфига

        (включается использование neh кеша в режиме записи в кеш), и обстреливает его предоставленым планом.

        На выходе - набранный кеш и результаты ответов верхнего.
    """

    type = 'BUILD_NOAPACHEUPPER_NEH_CACHE'

    input_parameters = ResponsesStandaloneNoapacheupper2.get_input_parameters(neh_cache_mode='write')

    def __init__(self, task_id=0):
        super(BuildNoapacheupperNehCache, self).__init__(task_id, neh_cache_mode='write')


def create_task_BuildNoapacheupperNehCache(
    noapacheupper_config_resource_id,
    noapacheupper_executable_resource_id,
    noapacheupper_data_resource_id,
    queries_resource_id,
    descr,
    apphost_mode=False,
    current_sdk2_task=None,
    run_mode=None,
):
    sub_ctx = {
        NoapacheupperParams.Config.name: noapacheupper_config_resource_id,
        NoapacheupperParams.Binary.name: noapacheupper_executable_resource_id,
        NoapacheupperParams.Data.name: noapacheupper_data_resource_id,
        NoapacheupperParams.AppHostMode.name: apphost_mode,
        request.ResourceParam.name: queries_resource_id,
    }
    if run_mode:
        sub_ctx[RunMode.name] = run_mode,

    logging.info("create {}({})".format(BuildNoapacheupperNehCache.type, str(sub_ctx)))
    if current_sdk2_task:
        return sdk2.Task[BuildNoapacheupperNehCache.type](
            current_sdk2_task,
            description=descr,
            arch="linux",
            priority=current_sdk2_task.Parameters.priority,
            **sub_ctx
        ).enqueue()
    else:
        return channel.task.create_subtask(
            task_type=BuildNoapacheupperNehCache.type,
            description=descr,
            input_parameters=sub_ctx,
            arch="linux",
            model="e5-2660",
        )


__Task__ = BuildNoapacheupperNehCache
