# -*- coding: utf-8 -*-

import copy

from sandbox.projects.websearch import release_setup
from sandbox.projects.common.noapacheupper.search_component import Params as NoapacheupperParams
from sandbox.projects.common.noapacheupper.standalone import ResponsesStandaloneNoapacheupper2
from sandbox.projects.common.search import bugbanner
from sandbox.projects.common import utils
from sandbox.projects.websearch.upper.BuildNoapacheupperConfig import BuildNoapacheupperConfig, create_noapache_config_builder_task
from sandbox.projects.websearch.upper.GetStandaloneNoapacheupperResponses2 import create_task_GetStandaloneNoapacheupperResponses4Ctx

from sandbox.sandboxsdk.channel import channel


class ExtremeStandaloneNoapacheupper(bugbanner.BugBannerTask):
    """
        Метатест для запуска/обстрела noapache на устойчивость в экстремальных условиях
        (наличия группировок документов с пустыми группами/документами, отсутствие источников в конфигурационном файле или неответы источников)
        тест состоит в генерации конфигов для этих целей и прогонов теста получения ответов от noapache с этими конфигами

        На входе:
            ресурсы, необходимые для запуска GET_STANDALONE_NOAPACHEUPPER_RESPONSES;

        На выходе:
            ожидается успешное выполнение всех запущенных подзадач (со специфичными конфигами)
    """

    type = "EXTREME_STANDALONE_NOAPACHEUPPER2"

    input_parameters = ResponsesStandaloneNoapacheupper2.get_input_parameters(neh_cache_mode='read')
    execution_space = 1024  # 1 Gb, max usage is less than 1 Gb
    build_config_tasks_id = "build_config_tasks_id"
    config_tasks_descr = "config_tasks_descr"
    get_noapache_responses_tasks_id = "get_noapache_responses_tasks_id"

    client_tags = release_setup.WEBSEARCH_TAGS_P1

    def on_execute(self):
        self.add_bugbanner(bugbanner.Banners.ReleaseMachine)

        if self.build_config_tasks_id not in self.ctx:
            # запускаем таски генерации конфигов
            cfg_tasks = []
            task_id_to_descr = {}

            def ext_config(**args):
                args['new_options_svn_url'] = '-'
                hr_hash = ', '.join(['{}={}'.format(k, v) for k, v in args.iteritems()])
                cfg_tasks.append(create_noapache_config_builder_task(
                    self.ctx[NoapacheupperParams.Config.name],
                    'patch config for extreme test ' + hr_hash,
                    **args
                ))
                task_id_to_descr[cfg_tasks[-1].id] = hr_hash

            ext_config(corrupt_groupings=True)
            ext_config(remove_sources='2:0')
            ext_config(remove_sources='2:1')
            ext_config(invalid_subsources='2:0')
            ext_config(invalid_subsources='2:1')

            self.ctx[self.build_config_tasks_id] = [t.id for t in cfg_tasks]
            self.ctx[self.config_tasks_descr] = task_id_to_descr

        elif self.get_noapache_responses_tasks_id not in self.ctx:
            # запускаем таски опроса noapache, использующие нагенерированные конфиги
            for tid in self.ctx[self.build_config_tasks_id]:
                ctx = copy.deepcopy(self.ctx)
                # взять resource id построенного конфига, использовать для опроса noapache
                ctx[NoapacheupperParams.Config.name] = channel.sandbox.get_task(tid).ctx[BuildNoapacheupperConfig.cfg_res_id]
                self.ctx.setdefault(self.get_noapache_responses_tasks_id, []).append(
                    create_task_GetStandaloneNoapacheupperResponses4Ctx(
                        ctx, 'extreme test: ' + str(self.ctx[self.config_tasks_descr][tid])
                    ).id
                )

        utils.check_subtasks_fails()


__Task__ = ExtremeStandaloneNoapacheupper
