# -*- coding: utf-8 -*-

from sandbox.projects.common.noapacheupper.standalone import EventlogStandaloneNoapacheupper


class GetStandaloneNoapacheupperEventlog(EventlogStandaloneNoapacheupper):
    """
        Обстрел noapacheupper с ипользованием данных из neh cache вместо опроса реальных источников,
        - поднимается безапачевый верхний, использующий поправленную версию предоставленнго конфига
        (включается использование neh кеша в режиме чтения из кеша), и обстреливается предоставленым планом запросов.

        На выходе - eventlog для последующего анализа.
    """

    type = 'GET_STANDALONE_NOAPACHEUPPER_EVENTLOG'

    execution_space = 15000  # 15G, 8G detected

    input_parameters = EventlogStandaloneNoapacheupper.get_input_parameters(neh_cache_mode='read')

    def __init__(self, task_id=0):
        super(GetStandaloneNoapacheupperEventlog, self).__init__(task_id, neh_cache_mode='read')


__Task__ = GetStandaloneNoapacheupperEventlog
