# -*- coding: utf-8 -*-

from sandbox.projects.common.noapacheupper.standalone import ResponsesStandaloneNoapacheupper
from sandbox.projects.websearch import release_setup


class GetStandaloneNoapacheupperResponses(ResponsesStandaloneNoapacheupper):
    """
        Обстрел noapacheupper с ипользованием данных из neh cache вместо опроса реальных источников,
        - поднимается безапачевый верхний, использующий поправленную версию предоставленнго конфига
        (включается использование neh кеша в режиме чтения из кеша), и обстреливается предоставленым планом запросов.

        На выходе - ответы noapacheupper для сравнения с другими результатами.
    """

    type = 'GET_STANDALONE_NOAPACHEUPPER_RESPONSES'

    client_tags = release_setup.WEBSEARCH_TAGS_P1

    input_parameters = ResponsesStandaloneNoapacheupper.get_input_parameters(neh_cache_mode='read')

    # 80 Gb DONT MAKE IT SMALLER or YOU WILL GET IOError: [Errno 28] No space left on device
    # Because now we have 20k requests instead of 5k!
    execution_space = 80 * 1024  # 80 Gb
    required_ram = 80 * 1024  # 80 Gb
    cores = 4

    def __init__(self, task_id=0):
        super(GetStandaloneNoapacheupperResponses, self).__init__(task_id, neh_cache_mode='read')


__Task__ = GetStandaloneNoapacheupperResponses
