# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common.noapacheupper.standalone import ResponsesStandaloneNoapacheupper2


class GetStandaloneNoapacheupperResponses(ResponsesStandaloneNoapacheupper2):
    """
        Обстрел noapacheupper с ипользованием данных из neh cache вместо опроса реальных источников,
        - поднимается безапачевый верхний, использующий поправленную версию предоставленнго конфига
        (включается использование neh кеша в режиме чтения из кеша), и обстреливается предоставленым планом запросов.

        На выходе - ответы noapachupper для сравнения с другими результатами.
    """

    type = 'GET_STANDALONE_NOAPACHEUPPER_RESPONSES2'
    execution_space = 12 * 1024  # 12 Gb
    required_ram = 80 * 1024  # 80 Gb
    input_parameters = ResponsesStandaloneNoapacheupper2.get_input_parameters(neh_cache_mode='read')

    def __init__(self, task_id=0):
        super(GetStandaloneNoapacheupperResponses, self).__init__(task_id, neh_cache_mode='read')


__Task__ = GetStandaloneNoapacheupperResponses


def create_task_GetStandaloneNoapacheupperResponses4Ctx(ctx, descr):
    sub_ctx = {}
    # отбираем из параметров метатаска только полезные
    parameters = ResponsesStandaloneNoapacheupper2.get_input_parameters(neh_cache_mode='read')
    for param in parameters:
        if param.name in ctx:
            sub_ctx[param.name] = ctx[param.name]

    logging.info("create {}({})".format(GetStandaloneNoapacheupperResponses.type, str(sub_ctx)))
    return channel.task.create_subtask(
        task_type=GetStandaloneNoapacheupperResponses.type,
        description=descr,
        input_parameters=sub_ctx,
        arch="linux",
    )
