import sandbox.projects.common.search.yasm as search_yasm
import sandbox.projects.websearch.upper.GetStandaloneNoapacheupperResponses as gsnr
import sandbox.projects.websearch.upper.resources as upper_res


_INSTANCE_TYPE = "noapache"
_INSTANCE_TAG = search_yasm.DEFAULT_INSTANCE_TAG + (("tier", "yandsearch"),)


class WebTestUpperUnistat(gsnr.GetStandaloneNoapacheupperResponses, search_yasm.YasmAgentTask):
    """
        Verify unistat implementation in web upper
    """
    input_parameters = gsnr.GetStandaloneNoapacheupperResponses.input_parameters + search_yasm.YasmAgentTask.input_parameters
    type = 'WEB_TEST_UPPER_UNISTAT'

    def on_enqueue(self):
        gsnr.GetStandaloneNoapacheupperResponses.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            upper_res.UpperUnistatSignals,
        )

    def save_responses(self, search_component, responses_resource_path, unpacked_responses_resource_path=None):
        yasmagent = self._yasmagent(search_component, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        with yasmagent, yasmlistener:
            gsnr.GetStandaloneNoapacheupperResponses.save_responses(
                self, search_component, responses_resource_path, unpacked_responses_resource_path
            )
        yasmlistener.dump(self.__unistat_signals())

    def _set_yasm_config_options(self, config_object):
        config_object.set("options_unistat", "url", "/tass?level=1&allholes=1")
        config_object.set("options_unistat", "max_sig_count", 8000)

    def __unistat_signals(self):
        return self.abs_path("upper-unistat-signals.txt")
