import json
import argparse
from yt import wrapper as yw
from yt.logger import LOGGER as yt_logger


class SoyTableBuilder:  # mapper
    def __init__(self, service_url, features):
        self.service_url = service_url
        self.features = features if features else ('numdocs', 'direct', 'query')

    def __call__(self, row):
        cookies = []
        headers = []
        _id = 't{}r{}'.format(row['@table_index'], row['@row_index'])
        method = 'GET'
        uri = '{}{}/?{}'.format(self.service_url, row['handle'], row['request_params'])
        userdata = json.dumps({'check_features': self.features})
        yield {'cookies': cookies, 'headers': headers, 'id': _id, 'method': method, 'uri': uri, 'userdata': userdata}


def main(args):
    yw.config['pickling']['python_binary'] = '/skynet/python/bin/python'
    blacklist = {'search-result', 'search-result-pad', 'search-result-touch'}

    def is_good(_path):
        return yw.ypath_split(_path)[1] not in blacklist

    def truncate(_path, limit):
        return yw.TablePath(_path, start_index=yw.row_count(path)-limit)

    input_paths = filter(is_good, yw.search(args.input_path, ['table']))
    yt_logger.info('Input paths: {}'.format(', '.join(input_paths)))
    if args.limit > 0:
        input_paths = [truncate(path, args.limit) for path in input_paths]
    yw.create('table', args.output_path, recursive=True, ignore_existing=True)
    yw.run_map(
        SoyTableBuilder(args.service, args.features),
        input_paths,
        args.output_path,
        format=yw.YsonFormat(control_attributes_mode='row_fields'),
        spec={'job_io': {'control_attributes': {'enable_row_index': True, 'enable_table_index': True}}},
    )
    yw.run_sort(args.output_path, sort_by=['id'])


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Build table with requests for SoY')
    parser.add_argument('--service', required=True, help='Service where to send requests to')
    parser.add_argument('--input-path', required=True, help='Cypress table or dir with prepared requests')
    parser.add_argument('--output-path', required=True, help='Output table path')
    parser.add_argument('--limit', type=int, default=1000, help='Number of requests for each handle')
    parser.add_argument('--features', nargs='*', help='Features to calculate for these requests')
    main(parser.parse_args())
